/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.actions;

import java.time.Duration;
import java.util.concurrent.TimeUnit;
import org.citrusframework.AbstractTestActionBuilder;
import org.citrusframework.actions.AbstractTestAction;
import org.citrusframework.context.TestContext;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SleepAction
extends AbstractTestAction {
    private final String time;
    private final TimeUnit timeUnit;
    private static final Logger logger = LoggerFactory.getLogger(SleepAction.class);

    private SleepAction(Builder builder) {
        super("sleep", builder);
        this.time = builder.time;
        this.timeUnit = builder.timeUnit;
    }

    @Override
    public void doExecute(TestContext context) {
        String duration = context.resolveDynamicValue(this.time);
        try {
            block8: {
                block7: {
                    logger.info(String.format("Sleeping %s %s", new Object[]{duration, this.timeUnit}));
                    if (duration.indexOf(".") <= 0) break block7;
                    switch (this.timeUnit) {
                        case MILLISECONDS: {
                            TimeUnit.MILLISECONDS.sleep(Math.round(Double.parseDouble(duration)));
                            break block8;
                        }
                        case SECONDS: {
                            TimeUnit.MILLISECONDS.sleep(Math.round(Double.parseDouble(duration) * 1000.0));
                            break block8;
                        }
                        case MINUTES: {
                            TimeUnit.MILLISECONDS.sleep(Math.round(Double.parseDouble(duration) * 60.0 * 1000.0));
                            break block8;
                        }
                        default: {
                            throw new CitrusRuntimeException("Unsupported time expression for sleep action - please use one of milliseconds, seconds, minutes");
                        }
                    }
                }
                this.timeUnit.sleep(Long.parseLong(duration));
            }
            logger.info(String.format("Returning after %s %s", new Object[]{duration, this.timeUnit}));
        }
        catch (InterruptedException e) {
            throw new CitrusRuntimeException((Throwable)e);
        }
    }

    public String getTime() {
        return this.time;
    }

    public TimeUnit getTimeUnit() {
        return this.timeUnit;
    }

    public static final class Builder
    extends AbstractTestActionBuilder<SleepAction, Builder> {
        private String time = "5000";
        private TimeUnit timeUnit = TimeUnit.MILLISECONDS;

        public static Builder delay() {
            return new Builder();
        }

        public static Builder sleep() {
            return new Builder();
        }

        public Builder milliseconds(Integer milliseconds) {
            return this.time(String.valueOf(milliseconds), TimeUnit.MILLISECONDS);
        }

        public Builder milliseconds(Long milliseconds) {
            return this.time(String.valueOf(milliseconds), TimeUnit.MILLISECONDS);
        }

        public Builder milliseconds(String expression) {
            this.time(expression, TimeUnit.MILLISECONDS);
            return this;
        }

        public Builder seconds(Double seconds) {
            this.milliseconds(Math.round(seconds * 1000.0));
            return this;
        }

        public Builder seconds(Integer seconds) {
            return this.time(String.valueOf((long)seconds.intValue() * 1000L), TimeUnit.MILLISECONDS);
        }

        public Builder seconds(Long seconds) {
            return this.time(String.valueOf(seconds * 1000L), TimeUnit.MILLISECONDS);
        }

        public Builder time(Duration duration) {
            this.milliseconds(duration.toMillis());
            return this;
        }

        public Builder time(String expression, TimeUnit timeUnit) {
            this.time = expression;
            this.timeUnit = timeUnit;
            return this;
        }

        public SleepAction build() {
            return new SleepAction(this);
        }
    }
}

