/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.validation;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.citrusframework.context.TestContext;
import org.citrusframework.exceptions.ValidationException;
import org.citrusframework.util.StringUtils;
import org.citrusframework.validation.HeaderValidator;
import org.citrusframework.validation.context.HeaderValidationContext;
import org.citrusframework.validation.matcher.ValidationMatcherUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultHeaderValidator
implements HeaderValidator {
    private static final Logger logger = LoggerFactory.getLogger(DefaultHeaderValidator.class);
    private static final Map<String, HeaderValidator> DEFAULT_VALIDATORS = HeaderValidator.lookup();

    public void validateHeader(String headerName, Object receivedValue, Object controlValue, TestContext context, HeaderValidationContext validationContext) {
        Optional<HeaderValidator> validator = DefaultHeaderValidator.getHeaderValidator(headerName, controlValue, context);
        if (validator.isPresent()) {
            validator.get().validateHeader(headerName, receivedValue, controlValue, context, validationContext);
            return;
        }
        String expectedValue = Optional.ofNullable(controlValue).map(value -> (String)context.getTypeConverter().convertIfNecessary(value, String.class)).map(arg_0 -> ((TestContext)context).replaceDynamicContentInString(arg_0)).orElse("");
        if (receivedValue != null) {
            String receivedValueString = (String)context.getTypeConverter().convertIfNecessary(receivedValue, String.class);
            if (ValidationMatcherUtils.isValidationMatcherExpression((String)expectedValue)) {
                ValidationMatcherUtils.resolveValidationMatcher((String)headerName, (String)receivedValueString, (String)expectedValue, (TestContext)context);
                return;
            }
            if (!receivedValueString.equals(expectedValue)) {
                throw new ValidationException("Values not equal for header element '" + headerName + "', expected '" + expectedValue + "' but was '" + receivedValue + "'");
            }
        } else if (StringUtils.hasText(expectedValue)) {
            throw new ValidationException("Values not equal for header element '" + headerName + "', expected '" + expectedValue + "' but was 'null'");
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Validating header element: " + headerName + "='" + expectedValue + "': OK");
        }
    }

    public boolean supports(String headerName, Class<?> type) {
        return type == null || type.isInstance(String.class) || type.isPrimitive();
    }

    private static Optional<HeaderValidator> getHeaderValidator(String headerName, Object controlValue, TestContext context) {
        HashMap<String, HeaderValidator> allValidators = new HashMap<String, HeaderValidator>(DEFAULT_VALIDATORS);
        allValidators.putAll(context.getReferenceResolver().resolveAll(HeaderValidator.class));
        return allValidators.values().stream().filter(validator -> !(validator instanceof DefaultHeaderValidator)).filter(validator -> validator.supports(headerName, (Class)Optional.ofNullable(controlValue).map(Object::getClass).orElse(null))).findFirst();
    }
}

