/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework;

import org.citrusframework.CitrusContext;
import org.citrusframework.CitrusContextProvider;
import org.citrusframework.CitrusInstanceManager;
import org.citrusframework.CitrusVersion;
import org.citrusframework.TestAction;
import org.citrusframework.container.AfterSuite;
import org.citrusframework.container.BeforeSuite;
import org.citrusframework.context.TestContext;
import org.citrusframework.report.MessageListener;
import org.citrusframework.report.MessageListenerAware;
import org.citrusframework.report.TestListener;
import org.citrusframework.report.TestListenerAware;
import org.citrusframework.report.TestReporter;
import org.citrusframework.report.TestReporterAware;
import org.citrusframework.report.TestSuiteListener;
import org.citrusframework.report.TestSuiteListenerAware;

public final class Citrus
implements TestListenerAware,
TestSuiteListenerAware,
TestReporterAware,
MessageListenerAware {
    private final CitrusContext citrusContext;

    Citrus(CitrusContext citrusContext) {
        this.citrusContext = citrusContext;
    }

    public static Citrus newInstance() {
        return CitrusInstanceManager.newInstance();
    }

    public static Citrus newInstance(CitrusContextProvider contextProvider) {
        return CitrusInstanceManager.newInstance(contextProvider);
    }

    public void beforeSuite(String suiteName, String ... testGroups) {
        this.citrusContext.getTestSuiteListeners().onStart();
        for (BeforeSuite sequenceBeforeSuite : this.citrusContext.getBeforeSuite()) {
            try {
                if (!sequenceBeforeSuite.shouldExecute(suiteName, testGroups)) continue;
                sequenceBeforeSuite.execute(this.citrusContext.createTestContext());
            }
            catch (Exception e) {
                this.citrusContext.getTestSuiteListeners().onStartFailure((Throwable)e);
                this.afterSuite(suiteName, testGroups);
                throw new AssertionError("Before suite failed with errors", e);
            }
        }
        this.citrusContext.getTestSuiteListeners().onStartSuccess();
    }

    public void afterSuite(String suiteName, String ... testGroups) {
        this.citrusContext.getTestSuiteListeners().onFinish();
        for (AfterSuite sequenceAfterSuite : this.citrusContext.getAfterSuite()) {
            try {
                if (!sequenceAfterSuite.shouldExecute(suiteName, testGroups)) continue;
                sequenceAfterSuite.execute(this.citrusContext.createTestContext());
            }
            catch (Exception e) {
                this.citrusContext.getTestSuiteListeners().onFinishFailure((Throwable)e);
                throw new AssertionError("After suite failed with errors", e);
            }
        }
        this.citrusContext.getTestSuiteListeners().onFinishSuccess();
    }

    public void run(TestAction action) {
        this.run(action, this.citrusContext.createTestContext());
    }

    public void run(TestAction action, TestContext testContext) {
        action.execute(testContext);
    }

    public static String getVersion() {
        return CitrusVersion.version();
    }

    public void addTestSuiteListener(TestSuiteListener suiteListener) {
        this.citrusContext.addTestSuiteListener(suiteListener);
    }

    public void addTestListener(TestListener testListener) {
        this.citrusContext.addTestListener(testListener);
    }

    public void addTestReporter(TestReporter testReporter) {
        this.citrusContext.addTestReporter(testReporter);
    }

    public void addMessageListener(MessageListener listener) {
        this.citrusContext.addMessageListener(listener);
    }

    public CitrusContext getCitrusContext() {
        return this.citrusContext;
    }

    public void close() {
        this.citrusContext.close();
    }
}

