/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.common;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.tools.JavaCompiler;
import javax.tools.ToolProvider;
import org.citrusframework.annotations.CitrusAnnotations;
import org.citrusframework.common.DefaultTestLoader;
import org.citrusframework.common.TestSourceAware;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.spi.Resource;
import org.citrusframework.util.FileUtils;
import org.citrusframework.util.ReflectionHelper;
import org.citrusframework.util.StringUtils;

public class JavaTestLoader
extends DefaultTestLoader
implements TestSourceAware {
    private static final Pattern packageNamePattern = Pattern.compile("^package\\s+([a-zA-Z_][.a-zA-Z_]+);$", 8);
    private String source;

    @Override
    public void doLoad() {
        Resource javaSource = FileUtils.getFileResource(this.getSource());
        try {
            JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
            int success = compiler.run(null, null, null, javaSource.getFile().getAbsolutePath());
            if (success != 0) {
                throw new CitrusRuntimeException("Failed to compile Java source file: %s".formatted(javaSource.getFile().getAbsolutePath()));
            }
            String packageName = JavaTestLoader.extractPackageName(javaSource);
            String qualifiedClassName = StringUtils.hasText(packageName) ? packageName + "." + this.getClassName() : this.getClassName();
            URLClassLoader classLoader = URLClassLoader.newInstance(new URL[]{JavaTestLoader.getClassLoaderBaseURL(packageName, javaSource)});
            Class<?> cls = Class.forName(qualifiedClassName, true, classLoader);
            Object instance = cls.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            CitrusAnnotations.injectAll(instance, this.citrus, this.context);
            CitrusAnnotations.injectTestRunner(instance, this.runner);
            this.doWithTestCase(tc -> {
                try {
                    ReflectionHelper.invokeMethod((Method)instance.getClass().getDeclaredMethod("run", new Class[0]), (Object)instance, (Object[])new Object[0]);
                }
                catch (NoSuchMethodException e) {
                    throw new CitrusRuntimeException("Failed to run Java test method 'run()' on class: %s".formatted(instance.getClass()), (Throwable)e);
                }
            });
            super.doLoad();
        }
        catch (IOException | ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw this.context.handleError(this.testName, this.packageName, "Failed to load Java test with name '" + this.testName + "'", e);
        }
    }

    public String getSource() {
        if (StringUtils.hasText(this.source)) {
            return this.source;
        }
        String path = StringUtils.hasText(this.packageName) ? this.packageName.replace('.', '/') : "";
        Object fileName = this.testName.endsWith(".java") ? this.testName : this.testName + ".java";
        return StringUtils.hasText(path) ? path + "/" + (String)fileName : fileName;
    }

    public String getClassName() {
        if (StringUtils.hasText(this.source)) {
            if (this.source.contains(":")) {
                return FileUtils.getBaseName(FileUtils.getFileName(this.source.substring(this.source.indexOf(":"))));
            }
            return FileUtils.getBaseName(FileUtils.getFileName(this.source));
        }
        return FileUtils.getBaseName((String)(this.testName.endsWith(".java") ? this.testName : this.testName + ".java"));
    }

    private static String extractPackageName(Resource javaSource) throws IOException {
        String content = FileUtils.readToString(javaSource);
        Matcher matcher = packageNamePattern.matcher(content);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return "";
    }

    private static URL getClassLoaderBaseURL(String packageName, Resource javaSource) throws MalformedURLException {
        Path clBase = Paths.get(javaSource.getURI()).getParent();
        if (StringUtils.hasText(packageName)) {
            for (int i = 0; i < packageName.split("\\.").length; ++i) {
                clBase = clBase.getParent();
            }
        }
        return clBase.toUri().toURL();
    }

    public void setSource(String source) {
        this.source = source;
    }
}

