/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.functions.core;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.List;
import org.citrusframework.context.TestContext;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.functions.core.AbstractDateFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CurrentDateFunction
extends AbstractDateFunction {
    private static final Logger logger = LoggerFactory.getLogger(CurrentDateFunction.class);

    public String execute(List<String> parameterList, TestContext context) {
        String result;
        Calendar calendar = Calendar.getInstance();
        SimpleDateFormat dateFormat = parameterList != null && !parameterList.isEmpty() ? new SimpleDateFormat(parameterList.get(0)) : this.getDefaultDateFormat();
        if (parameterList != null && parameterList.size() > 1) {
            this.applyDateOffset(calendar, parameterList.get(1));
        }
        try {
            result = dateFormat.format(calendar.getTime());
        }
        catch (RuntimeException e) {
            logger.error("Error while formatting date value ", (Throwable)e);
            throw new CitrusRuntimeException((Throwable)e);
        }
        return result;
    }
}

