/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.validation.matcher.core;

import java.util.List;
import java.util.UUID;
import org.citrusframework.context.TestContext;
import org.citrusframework.exceptions.ValidationException;
import org.citrusframework.validation.matcher.ValidationMatcher;

public class UuidV4ValidationMatcher
implements ValidationMatcher {
    public void validate(String fieldName, String value, List<String> controlParameters, TestContext context) throws ValidationException {
        try {
            UUID uuid = UUID.fromString(value);
            if (uuid.version() != 4) {
                this.throwValidationException(fieldName, value);
            }
        }
        catch (IllegalArgumentException e) {
            this.throwValidationException(fieldName, value);
        }
    }

    private void throwValidationException(String fieldName, String value) {
        throw new ValidationException(this.getClass().getSimpleName() + " failed for field '" + fieldName + "'. Received value '" + value + "' is not a uuid v4.");
    }
}

