/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.actions;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.citrusframework.AbstractTestActionBuilder;
import org.citrusframework.actions.AbstractTestAction;
import org.citrusframework.context.TestContext;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateEndpointAction
extends AbstractTestAction {
    private final String endpointUri;
    private static final Logger logger = LoggerFactory.getLogger(CreateEndpointAction.class);

    private CreateEndpointAction(Builder builder) {
        super("create-endpoint", builder);
        this.endpointUri = builder.endpointUri;
    }

    @Override
    public void doExecute(TestContext context) {
        logger.info("Creating endpoint '{}'", (Object)this.endpointUri);
        context.getEndpointFactory().create(this.endpointUri, context);
    }

    public String getEndpointUri() {
        return this.endpointUri;
    }

    public static final class Builder
    extends AbstractTestActionBuilder<CreateEndpointAction, Builder> {
        private String endpointUri;
        private String type;
        private final Map<String, String> properties = new LinkedHashMap<String, String>();

        public static Builder createEndpoint(String type, Map<String, String> properties) {
            Builder builder = new Builder();
            builder.type(type);
            builder.properties(properties);
            return builder;
        }

        public static Builder createEndpoint(String endpointUri) {
            return new Builder().uri(endpointUri);
        }

        public static Builder createEndpoint() {
            return new Builder();
        }

        public Builder uri(String endpointUri) {
            this.endpointUri = endpointUri;
            return this;
        }

        public Builder type(String type) {
            this.type = type;
            return this;
        }

        public Builder endpointName(String name) {
            return this.property("endpointName", name);
        }

        public Builder property(String name, String value) {
            this.properties.put(name, value);
            return this;
        }

        public Builder properties(Map<String, String> properties) {
            this.properties.putAll(properties);
            return this;
        }

        public CreateEndpointAction build() {
            if (this.endpointUri == null && this.type == null) {
                throw new CitrusRuntimeException("Failed to build endpoint specification - please specify an endpoint URI or a type");
            }
            if (this.endpointUri == null) {
                this.endpointUri = this.properties.isEmpty() ? this.type : "%s?%s".formatted(this.type, this.properties.entrySet().stream().map(entry -> "%s=%s".formatted(entry.getKey(), entry.getValue())).collect(Collectors.joining("&")));
            }
            return new CreateEndpointAction(this);
        }
    }
}

