/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.actions;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import org.citrusframework.AbstractTestActionBuilder;
import org.citrusframework.actions.AbstractTestAction;
import org.citrusframework.context.TestContext;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.spi.Resource;
import org.citrusframework.util.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoadPropertiesAction
extends AbstractTestAction {
    private final String filePath;
    private static final Logger logger = LoggerFactory.getLogger(LoadPropertiesAction.class);

    public LoadPropertiesAction(Builder builder) {
        super("load", builder);
        this.filePath = builder.filePath;
    }

    @Override
    public void doExecute(TestContext context) {
        Resource resource = FileUtils.getFileResource(this.filePath, context);
        logger.debug("Reading property file {}", (Object)FileUtils.getFileName(resource.getLocation()));
        Properties props = FileUtils.loadAsProperties(resource);
        LinkedHashMap<String, String> unresolved = new LinkedHashMap<String, String>();
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            String key = entry.getKey().toString();
            logger.debug("Loading property: {}={} into variables", (Object)key, (Object)props.getProperty(key));
            if (logger.isDebugEnabled() && context.getVariables().containsKey(key)) {
                logger.debug("Overwriting property {} old value:{} new value:{}", new Object[]{key, context.getVariable(key), props.getProperty(key)});
            }
            try {
                context.setVariable(key, (Object)context.replaceDynamicContentInString(props.getProperty(key)));
            }
            catch (CitrusRuntimeException e) {
                unresolved.put(key, props.getProperty(key));
            }
        }
        context.resolveDynamicValuesInMap(unresolved).forEach((arg_0, arg_1) -> ((TestContext)context).setVariable(arg_0, arg_1));
        logger.info("Loaded property file {}", (Object)FileUtils.getFileName(resource.getLocation()));
    }

    public String getFilePath() {
        return this.filePath;
    }

    public static final class Builder
    extends AbstractTestActionBuilder<LoadPropertiesAction, Builder> {
        private String filePath;

        public static Builder load() {
            return new Builder();
        }

        public static Builder load(String filePath) {
            Builder builder = new Builder();
            builder.filePath(filePath);
            return builder;
        }

        public Builder filePath(String filePath) {
            this.filePath = filePath;
            return this;
        }

        public LoadPropertiesAction build() {
            return new LoadPropertiesAction(this);
        }
    }
}

