/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.actions;

import org.citrusframework.AbstractTestActionBuilder;
import org.citrusframework.actions.AbstractTestAction;
import org.citrusframework.context.TestContext;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StopTimeAction
extends AbstractTestAction {
    public static final String DEFAULT_TIMELINE_ID = "CITRUS_TIMELINE";
    public static final String DEFAULT_TIMELINE_VALUE_SUFFIX = "_VALUE";
    private final String id;
    private final String suffix;
    private static final Logger logger = LoggerFactory.getLogger(StopTimeAction.class);

    public StopTimeAction(Builder builder) {
        super("stop-time", builder);
        this.id = builder.id;
        this.suffix = builder.suffix;
    }

    @Override
    public void doExecute(TestContext context) {
        String timeLineId = context.replaceDynamicContentInString(this.id);
        String timeLineSuffix = context.replaceDynamicContentInString(this.suffix);
        try {
            if (context.getVariables().containsKey(timeLineId)) {
                long time = System.currentTimeMillis() - (Long)context.getVariable(timeLineId, Long.class);
                context.setVariable(timeLineId + timeLineSuffix, (Object)time);
                if (this.description != null) {
                    logger.info("TimeWatcher {} after {} ms ({})", new Object[]{timeLineId, time, this.description});
                } else {
                    logger.info("TimeWatcher {} after {} ms", (Object)timeLineId, (Object)time);
                }
            } else {
                logger.info("Starting TimeWatcher: {}", (Object)timeLineId);
                context.setVariable(timeLineId, (Object)System.currentTimeMillis());
                context.setVariable(timeLineId + timeLineSuffix, (Object)0L);
            }
        }
        catch (Exception e) {
            throw new CitrusRuntimeException((Throwable)e);
        }
    }

    public String getId() {
        return this.id;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public static final class Builder
    extends AbstractTestActionBuilder<StopTimeAction, Builder> {
        private String id = "CITRUS_TIMELINE";
        private String suffix = "_VALUE";

        public static Builder stopTime() {
            return new Builder();
        }

        public static Builder stopTime(String id) {
            Builder builder = new Builder();
            builder.id(id);
            return builder;
        }

        public static Builder stopTime(String id, String suffix) {
            Builder builder = new Builder();
            builder.id(id);
            builder.suffix(suffix);
            return builder;
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder suffix(String suffix) {
            this.suffix = suffix;
            return this;
        }

        public StopTimeAction build() {
            return new StopTimeAction(this);
        }
    }
}

