/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.condition;

import java.util.Optional;
import org.citrusframework.TestAction;
import org.citrusframework.condition.AbstractCondition;
import org.citrusframework.context.TestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActionCondition
extends AbstractCondition {
    private static final Logger logger = LoggerFactory.getLogger(ActionCondition.class);
    private TestAction action;
    private Exception caughtException;

    public ActionCondition() {
    }

    public ActionCondition(TestAction action) {
        this.action = action;
    }

    public boolean isSatisfied(TestContext context) {
        if (this.action == null) {
            return false;
        }
        try {
            this.action.execute(context);
        }
        catch (Exception e) {
            this.caughtException = e;
            logger.warn("Nested action did not perform as expected - {}", (Object)Optional.ofNullable(e.getMessage()).map(msg -> e.getClass().getName() + ": " + msg).orElseGet(() -> e.getClass().getName()));
            return false;
        }
        return true;
    }

    public String getSuccessMessage(TestContext context) {
        return String.format("Test action condition success - action '%s' did perform as expected", this.getActionName());
    }

    public String getErrorMessage(TestContext context) {
        if (this.caughtException != null) {
            return String.format("Failed to check test action condition - action '%s' did not perform as expected: %s", this.getActionName(), Optional.ofNullable(this.caughtException.getMessage()).map(msg -> this.caughtException.getClass().getName() + ": " + msg).orElseGet(() -> this.caughtException.getClass().getName()));
        }
        return String.format("Failed to check test action condition - action '%s' did not perform as expected", this.getActionName());
    }

    private String getActionName() {
        return Optional.ofNullable(this.action).map(TestAction::getName).orElse("unknown");
    }

    public TestAction getAction() {
        return this.action;
    }

    public void setAction(TestAction action) {
        this.action = action;
    }

    public Exception getCaughtException() {
        return this.caughtException;
    }

    public void setCaughtException(Exception caughtException) {
        this.caughtException = caughtException;
    }

    public String toString() {
        return "ActionCondition{action=" + this.action + ", caughtException=" + this.caughtException + ", name=" + this.getName() + "}";
    }
}

