/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.container;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.citrusframework.AbstractTestContainerBuilder;
import org.citrusframework.Completable;
import org.citrusframework.TestAction;
import org.citrusframework.TestActionBuilder;
import org.citrusframework.actions.AbstractTestAction;
import org.citrusframework.container.Sequence;
import org.citrusframework.container.TestActionContainer;
import org.citrusframework.context.TestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractActionContainer
extends AbstractTestAction
implements TestActionContainer,
Completable {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected List<TestActionBuilder<?>> actions;
    private final List<TestAction> executedActions = new ArrayList<TestAction>();
    private TestAction activeAction;

    public AbstractActionContainer(String name) {
        this(name, new Sequence.Builder());
    }

    public AbstractActionContainer(String name, AbstractTestContainerBuilder<?, ?> builder) {
        super(name, builder);
        this.actions = builder.getActions();
    }

    protected void executeAction(TestAction action, TestContext context) {
        try {
            this.setActiveAction(action);
            action.execute(context);
        }
        finally {
            this.setExecutedAction(action);
        }
    }

    public AbstractActionContainer setActions(List<TestAction> actions) {
        this.actions = actions.stream().map(action -> () -> action).collect(Collectors.toList());
        return this;
    }

    public AbstractActionContainer addTestActions(TestAction ... toAdd) {
        this.actions.addAll(Stream.of(toAdd).map(action -> () -> action).collect(Collectors.toList()));
        return this;
    }

    public AbstractActionContainer addTestActions(TestActionBuilder<?> ... toAdd) {
        this.actions.addAll(Arrays.asList(toAdd));
        return this;
    }

    public boolean isDone(TestContext context) {
        if (this.actions.isEmpty() || this.isDisabled(context)) {
            return true;
        }
        if (this.activeAction == null && this.executedActions.isEmpty()) {
            return true;
        }
        if (!this.executedActions.contains(this.activeAction)) {
            return false;
        }
        for (TestAction action : new ArrayList<TestAction>(this.executedActions)) {
            if (!(action instanceof Completable) || ((Completable)action).isDone(context)) continue;
            this.logger.debug("{} not completed yet", (Object)Optional.ofNullable(action.getName()).filter(name -> !name.trim().isEmpty()).orElseGet(() -> action.getClass().getName()));
            return false;
        }
        return true;
    }

    public List<TestAction> getActions() {
        return this.actions.stream().map(TestActionBuilder::build).collect(Collectors.toList());
    }

    public long getActionCount() {
        return this.actions.size();
    }

    public AbstractActionContainer addTestAction(TestAction action) {
        this.actions.add(() -> action);
        return this;
    }

    public AbstractActionContainer addTestAction(TestActionBuilder<?> action) {
        this.actions.add(action);
        return this;
    }

    public int getActionIndex(TestAction action) {
        return this.executedActions.indexOf(action);
    }

    public TestAction getActiveAction() {
        return this.activeAction;
    }

    public void setActiveAction(TestAction action) {
        this.activeAction = action;
    }

    public void setExecutedAction(TestAction action) {
        this.executedActions.add(action);
    }

    public List<TestAction> getExecutedActions() {
        return this.executedActions;
    }

    public TestAction getTestAction(int index) {
        if (index < this.executedActions.size()) {
            return this.executedActions.get(index);
        }
        return this.actions.get(index).build();
    }
}

