/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.container;

import java.util.Collections;
import java.util.List;
import org.citrusframework.AbstractExceptionContainerBuilder;
import org.citrusframework.TestAction;
import org.citrusframework.TestActionBuilder;
import org.citrusframework.container.AbstractActionContainer;
import org.citrusframework.context.TestContext;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.exceptions.ValidationException;
import org.citrusframework.validation.matcher.ValidationMatcherUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Assert
extends AbstractActionContainer {
    private final TestActionBuilder<?> action;
    private final Class<? extends Throwable> exception;
    private final String message;
    private static final Logger logger = LoggerFactory.getLogger(Assert.class);

    public Assert(Builder builder) {
        super("assert", builder);
        this.action = builder.action;
        this.exception = builder.exception;
        this.message = builder.message;
    }

    @Override
    public void doExecute(TestContext context) {
        logger.debug("Assert container asserting exceptions of type {}", (Object)this.exception.getSimpleName());
        try {
            this.executeAction(this.action.build(), context);
        }
        catch (Exception e) {
            logger.debug("Validating caught exception: {}", (Object)e.getMessage());
            if (!this.exception.isAssignableFrom(e.getClass())) {
                throw new ValidationException("Validation failed for asserted exception type - expected: '" + this.exception + "' but was: '" + e.getClass().getName() + "'", (Throwable)e);
            }
            if (this.message != null) {
                if (ValidationMatcherUtils.isValidationMatcherExpression((String)this.message)) {
                    ValidationMatcherUtils.resolveValidationMatcher((String)"message", (String)e.getLocalizedMessage(), (String)this.message, (TestContext)context);
                } else if (!context.replaceDynamicContentInString(this.message).equals(e.getLocalizedMessage())) {
                    throw new ValidationException("Validation failed for asserted exception message - expected: '" + this.message + "' but was: '" + e.getLocalizedMessage() + "'", (Throwable)e);
                }
            }
            logger.debug("Asserted exception is as expected ({}): {}", e.getClass(), (Object)e.getLocalizedMessage());
            logger.debug("Assert exception validation successful: All values OK");
            return;
        }
        throw new ValidationException("Missing asserted exception '" + this.exception + "'");
    }

    public TestAction getAction() {
        return this.action.build();
    }

    public String getMessage() {
        return this.message;
    }

    public Class<? extends Throwable> getException() {
        return this.exception;
    }

    @Override
    public TestAction getTestAction(int index) {
        return this.getAction();
    }

    @Override
    public List<TestAction> getActions() {
        return Collections.singletonList(this.getAction());
    }

    public static class Builder
    extends AbstractExceptionContainerBuilder<Assert, Builder> {
        private TestActionBuilder<?> action;
        private Class<? extends Throwable> exception = CitrusRuntimeException.class;
        private String message;

        public static Builder assertException() {
            return new Builder();
        }

        @Override
        public Builder actions(TestActionBuilder<?> ... actions) {
            this.action = actions[0];
            return (Builder)super.actions(actions[0]);
        }

        public Builder exception(Class<? extends Throwable> exception) {
            this.exception = exception;
            return this;
        }

        public Builder exception(String type) {
            try {
                this.exception = Class.forName(type);
            }
            catch (ClassNotFoundException e) {
                throw new CitrusRuntimeException(String.format("Failed to instantiate exception class of type '%s'", type), (Throwable)e);
            }
            return this;
        }

        public Builder message(String message) {
            this.message = message;
            return this;
        }

        public Builder action(TestAction action) {
            return this.action(() -> action);
        }

        public Builder action(TestActionBuilder<?> builder) {
            return this.actions(new TestActionBuilder[]{builder});
        }

        @Override
        public Assert doBuild() {
            return new Assert(this);
        }
    }
}

