/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.container;

import org.citrusframework.AbstractExceptionContainerBuilder;
import org.citrusframework.TestActionBuilder;
import org.citrusframework.container.AbstractActionContainer;
import org.citrusframework.context.TestContext;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Catch
extends AbstractActionContainer {
    private final String exception;
    private static final Logger logger = LoggerFactory.getLogger(Catch.class);

    public Catch(Builder builder) {
        super("catch", builder);
        this.exception = builder.exception;
    }

    @Override
    public void doExecute(TestContext context) {
        logger.debug("Catch container catching exceptions of type {}", (Object)this.exception);
        for (TestActionBuilder actionBuilder : this.actions) {
            try {
                this.executeAction(actionBuilder.build(), context);
            }
            catch (Exception e) {
                if (this.exception != null && this.exception.equals(e.getClass().getName())) {
                    logger.info("Caught exception {}: {}", e.getClass(), (Object)e.getLocalizedMessage());
                    continue;
                }
                throw new CitrusRuntimeException((Throwable)e);
            }
        }
    }

    public String getException() {
        return this.exception;
    }

    public static class Builder
    extends AbstractExceptionContainerBuilder<Catch, Builder> {
        private String exception = CitrusRuntimeException.class.getName();

        public static Builder catchException() {
            return new Builder();
        }

        public Builder exception(Class<? extends Throwable> exception) {
            this.exception = exception.getName();
            return this;
        }

        public Builder exception(String type) {
            this.exception = type;
            return this;
        }

        @Override
        public Catch doBuild() {
            return new Catch(this);
        }
    }
}

