/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.container;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.citrusframework.AbstractTestActionBuilder;
import org.citrusframework.TestAction;
import org.citrusframework.TestActionBuilder;
import org.citrusframework.actions.AbstractTestAction;
import org.citrusframework.container.TemplateLoader;
import org.citrusframework.context.TestContext;
import org.citrusframework.context.TestContextFactory;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.functions.FunctionUtils;
import org.citrusframework.spi.ReferenceResolver;
import org.citrusframework.spi.ReferenceResolverAware;
import org.citrusframework.spi.SimpleReferenceResolver;
import org.citrusframework.util.FileUtils;
import org.citrusframework.variable.VariableUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Template
extends AbstractTestAction {
    private final List<TestActionBuilder<?>> actions;
    private final String templateName;
    private final Map<String, String> parameter;
    private final boolean globalContext;
    private static final Logger logger = LoggerFactory.getLogger(Template.class);

    public Template(AbstractTemplateBuilder<? extends Template, ?> builder) {
        super(Optional.ofNullable(builder.templateName).map(name -> "template:" + name).orElse("template"), builder);
        this.templateName = builder.templateName;
        this.actions = builder.actions;
        this.parameter = builder.parameter;
        this.globalContext = builder.globalContext;
    }

    @Override
    public void doExecute(TestContext context) {
        logger.debug("Executing template '{}' with {} embedded actions", (Object)this.getTemplateName(), (Object)this.actions.size());
        TestContext innerContext = this.globalContext ? context : TestContextFactory.copyOf(context);
        for (Map.Entry<String, String> entry : this.parameter.entrySet()) {
            String param = entry.getKey();
            String paramValue = entry.getValue();
            paramValue = VariableUtils.replaceVariablesInString((String)paramValue, (TestContext)innerContext, (boolean)false);
            if (context.getFunctionRegistry().isFunction(paramValue)) {
                paramValue = FunctionUtils.resolveFunction((String)paramValue, (TestContext)context);
            }
            logger.debug("Setting parameter for template {}={}", (Object)param, (Object)paramValue);
            innerContext.setVariable(param, (Object)paramValue);
        }
        for (TestActionBuilder testActionBuilder : this.actions) {
            testActionBuilder.build().execute(innerContext);
        }
        logger.info("Template '{}' was executed successfully", (Object)this.getTemplateName());
    }

    public Map<String, String> getParameter() {
        return this.parameter;
    }

    public boolean isGlobalContext() {
        return this.globalContext;
    }

    public List<TestAction> getActions() {
        return this.actions.stream().map(TestActionBuilder::build).collect(Collectors.toList());
    }

    public List<TestActionBuilder<?>> getActionBuilders() {
        return this.actions;
    }

    public String getTemplateName() {
        return this.templateName;
    }

    public static abstract class AbstractTemplateBuilder<T extends Template, B extends AbstractTemplateBuilder<T, B>>
    extends AbstractTestActionBuilder<T, B>
    implements ReferenceResolverAware {
        private String templateName;
        private final List<TestActionBuilder<?>> actions = new ArrayList();
        private final Map<String, String> parameter = new LinkedHashMap<String, String>();
        private boolean globalContext = true;
        protected ReferenceResolver referenceResolver;

        public B templateName(String templateName) {
            this.templateName = templateName;
            return (B)((AbstractTemplateBuilder)this.self);
        }

        public B globalContext(boolean globalContext) {
            this.globalContext = globalContext;
            return (B)((AbstractTemplateBuilder)this.self);
        }

        public B parameters(Map<String, String> parameters) {
            this.parameter.putAll(parameters);
            return (B)((AbstractTemplateBuilder)this.self);
        }

        public B parameter(String name, String value) {
            this.parameter.put(name, value);
            return (B)((AbstractTemplateBuilder)this.self);
        }

        public B actions(TestAction ... actions) {
            return this.actions(Arrays.asList(actions));
        }

        public B actions(List<TestAction> actions) {
            return this.actions(actions.stream().map(action -> () -> action).toList().toArray(new TestActionBuilder[0]));
        }

        public B actions(TestActionBuilder<?> ... actions) {
            for (int i = 0; i < actions.length; ++i) {
                TestActionBuilder<?> current = actions[i];
                if (this.actions.size() == i) {
                    this.actions.add(current);
                    continue;
                }
                if (this.resolveActionBuilder(this.actions.get(i)).equals(this.resolveActionBuilder(current))) continue;
                this.actions.add(i, current);
            }
            return (B)((AbstractTemplateBuilder)this.self);
        }

        public B withReferenceResolver(ReferenceResolver referenceResolver) {
            this.referenceResolver = referenceResolver;
            return (B)((AbstractTemplateBuilder)this.self);
        }

        public void setReferenceResolver(ReferenceResolver referenceResolver) {
            this.referenceResolver = referenceResolver;
        }

        public List<TestActionBuilder<?>> getActions() {
            return this.actions;
        }

        protected void onBuild() {
            if (this.referenceResolver != null && this.templateName != null) {
                Template rootTemplate = (Template)this.referenceResolver.resolve(this.templateName, Template.class);
                this.globalContext(rootTemplate.isGlobalContext() && this.globalContext);
                this.actor(Optional.ofNullable(this.getActor()).orElseGet(rootTemplate::getActor));
                LinkedHashMap<String, String> mergedParameters = new LinkedHashMap<String, String>();
                mergedParameters.putAll(rootTemplate.getParameter());
                mergedParameters.putAll(this.parameter);
                this.parameters(mergedParameters);
                this.actions((TestActionBuilder[])rootTemplate.getActionBuilders().toArray(TestActionBuilder[]::new));
            }
        }

        private TestActionBuilder<?> resolveActionBuilder(TestActionBuilder<?> builder) {
            if (builder instanceof TestActionBuilder.DelegatingTestActionBuilder) {
                TestActionBuilder.DelegatingTestActionBuilder delegatingTestActionBuilder = (TestActionBuilder.DelegatingTestActionBuilder)builder;
                return this.resolveActionBuilder(delegatingTestActionBuilder.getDelegate());
            }
            return builder;
        }
    }

    public static class Builder
    extends AbstractTemplateBuilder<Template, Builder>
    implements ReferenceResolverAware {
        private String filePath;
        private TemplateLoader loader;

        public static Builder applyTemplate() {
            return new Builder();
        }

        public Builder file(String filePath) {
            this.filePath = filePath;
            return this;
        }

        public Builder loader(TemplateLoader loader) {
            this.loader = loader;
            return this;
        }

        public static Builder applyTemplate(String name) {
            Builder builder = new Builder();
            builder.templateName(name);
            return builder;
        }

        public Template build() {
            if (this.filePath != null) {
                if (this.loader == null) {
                    Optional<TemplateLoader> resolved = TemplateLoader.lookup(FileUtils.getFileExtension(this.filePath));
                    if (resolved.isPresent()) {
                        this.loader = resolved.get();
                    } else {
                        throw new CitrusRuntimeException(String.format("Failed to find proper template loader for file '%s'", this.filePath));
                    }
                }
                this.loader.setReferenceResolver(this.referenceResolver);
                Template local = this.loader.load(this.filePath);
                SimpleReferenceResolver temporaryReferenceResolver = new SimpleReferenceResolver();
                temporaryReferenceResolver.bind(local.getTemplateName(), (Object)local);
                this.withReferenceResolver((ReferenceResolver)temporaryReferenceResolver);
                this.templateName(local.getTemplateName());
            }
            this.onBuild();
            return new Template(this);
        }
    }
}

