/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.container;

import java.util.TimerTask;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.citrusframework.AbstractTestContainerBuilder;
import org.citrusframework.TestActionBuilder;
import org.citrusframework.container.AbstractActionContainer;
import org.citrusframework.container.StopTimer;
import org.citrusframework.context.TestContext;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Timer
extends AbstractActionContainer
implements StopTimer {
    private static final Logger logger = LoggerFactory.getLogger(Timer.class);
    private static final AtomicInteger nextSerialNumber = new AtomicInteger(0);
    protected static final String INDEX_SUFFIX = "-index";
    private final long interval;
    private final long delay;
    private final int repeatCount;
    private final boolean fork;
    private final boolean autoStop;
    private final String timerId;
    protected AtomicBoolean timerComplete = new AtomicBoolean(false);
    protected CitrusRuntimeException timerException = null;
    private java.util.Timer timer;
    private ExecutorService taskExecutor;

    public Timer(Builder builder) {
        super("timer", builder);
        this.interval = builder.interval;
        this.delay = builder.delay;
        this.repeatCount = builder.repeatCount;
        this.fork = builder.fork;
        this.autoStop = builder.autoStop;
        this.timerId = builder.timerId;
    }

    @Override
    public void doExecute(TestContext context) {
        this.timer = new java.util.Timer(this.getTimerId(), false);
        if (this.fork) {
            this.taskExecutor = Executors.newSingleThreadExecutor();
            this.taskExecutor.execute(() -> this.configureAndRunTimer(context));
        } else {
            this.configureAndRunTimer(context);
        }
    }

    private void configureAndRunTimer(final TestContext context) {
        context.registerTimer(this.getTimerId(), (StopTimer)this);
        TimerTask timerTask = new TimerTask(){
            int indexCount = 0;

            @Override
            public void run() {
                try {
                    ++this.indexCount;
                    this.updateIndexCountInTestContext(context);
                    logger.debug("Timer event fired #{} - executing nested actions", (Object)this.indexCount);
                    for (TestActionBuilder actionBuilder : Timer.this.actions) {
                        Timer.this.executeAction(actionBuilder.build(), context);
                    }
                    if (this.indexCount >= Timer.this.repeatCount) {
                        logger.debug("Timer complete: {} iterations reached", (Object)Timer.this.repeatCount);
                        Timer.this.stopTimer();
                    }
                }
                catch (Exception e) {
                    this.handleException(e);
                }
            }

            private void updateIndexCountInTestContext(TestContext context2) {
                context2.setVariable(Timer.this.getTimerId() + Timer.INDEX_SUFFIX, (Object)String.valueOf(this.indexCount));
            }

            private void handleException(Exception e) {
                Timer.this.timerException = e instanceof CitrusRuntimeException ? (CitrusRuntimeException)((Object)e) : new CitrusRuntimeException((Throwable)e);
                logger.error("Timer stopped as a result of nested action error ({})", (Object)e.getMessage());
                Timer.this.stopTimer();
                if (Timer.this.fork) {
                    context.addException(Timer.this.timerException);
                }
            }
        };
        this.timer.scheduleAtFixedRate(timerTask, this.delay, this.interval);
        while (!this.timerComplete.get()) {
            try {
                Thread.sleep(this.interval);
            }
            catch (InterruptedException e) {
                logger.warn("Interrupted while waiting for timer to complete", (Throwable)e);
            }
        }
        if (this.timerException != null) {
            throw this.timerException;
        }
    }

    public String getTimerId() {
        return this.timerId;
    }

    public void stopTimer() {
        if (this.timerComplete.compareAndSet(false, true)) {
            if (this.fork && this.taskExecutor != null) {
                this.taskExecutor.shutdown();
            }
            if (this.timer != null) {
                this.timer.cancel();
            }
        }
    }

    private static int serialNumber() {
        return nextSerialNumber.getAndIncrement();
    }

    public long getInterval() {
        return this.interval;
    }

    public long getDelay() {
        return this.delay;
    }

    public int getRepeatCount() {
        return this.repeatCount;
    }

    public boolean isFork() {
        return this.fork;
    }

    @Override
    public boolean isDone(TestContext context) {
        if (this.fork) {
            if (this.autoStop) {
                this.stopTimer();
            } else {
                return true;
            }
        }
        return super.isDone(context);
    }

    public static class Builder
    extends AbstractTestContainerBuilder<Timer, Builder> {
        private long interval = 1000L;
        private long delay = 0L;
        private int repeatCount = Integer.MAX_VALUE;
        private boolean fork = false;
        private boolean autoStop = true;
        private String timerId;

        public static Builder timer() {
            return new Builder();
        }

        public Builder delay(long delay) {
            this.delay = delay;
            return this;
        }

        public Builder interval(long interval) {
            this.interval = interval;
            return this;
        }

        public Builder repeatCount(int repeatCount) {
            this.repeatCount = repeatCount;
            return this;
        }

        public Builder fork(boolean fork) {
            this.fork = fork;
            return this;
        }

        public Builder autoStop(boolean autoStop) {
            this.autoStop = autoStop;
            return this;
        }

        public Builder id(String timerId) {
            this.timerId = timerId;
            return this;
        }

        public Builder timerId(String timerId) {
            this.timerId = timerId;
            return this;
        }

        @Override
        public Timer doBuild() {
            if (StringUtils.isEmpty(this.timerId)) {
                this.timerId = "citrus-timer-" + Timer.serialNumber();
            }
            return new Timer(this);
        }
    }
}

