/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.container;

import java.time.Duration;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.citrusframework.AbstractTestActionBuilder;
import org.citrusframework.TestActionBuilder;
import org.citrusframework.actions.AbstractTestAction;
import org.citrusframework.condition.ActionCondition;
import org.citrusframework.condition.Condition;
import org.citrusframework.condition.FileCondition;
import org.citrusframework.condition.HttpCondition;
import org.citrusframework.condition.MessageCondition;
import org.citrusframework.container.WaitActionConditionBuilder;
import org.citrusframework.container.WaitConditionBuilder;
import org.citrusframework.container.WaitFileConditionBuilder;
import org.citrusframework.container.WaitHttpConditionBuilder;
import org.citrusframework.container.WaitMessageConditionBuilder;
import org.citrusframework.context.TestContext;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Wait
extends AbstractTestAction {
    private static final Logger logger = LoggerFactory.getLogger(Wait.class);
    private final Condition condition;
    private final String time;
    private final String interval;

    public Wait(Builder builder) {
        super("wait", builder);
        this.condition = builder.condition;
        this.time = builder.time;
        this.interval = builder.interval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doExecute(TestContext context) {
        Boolean conditionSatisfied = null;
        long timeLeft = this.getWaitTimeMs(context);
        long intervalMs = this.getIntervalMs(context);
        if (intervalMs > timeLeft) {
            intervalMs = timeLeft;
        }
        Callable<Boolean> callable = () -> this.condition.isSatisfied(context);
        while (timeLeft > 0L) {
            timeLeft -= intervalMs;
            logger.debug("Waiting for condition {}", (Object)this.condition.getName());
            ExecutorService executor = Executors.newSingleThreadExecutor();
            long checkStartTime = System.currentTimeMillis();
            try {
                Future<Boolean> future = executor.submit(callable);
                conditionSatisfied = future.get(intervalMs, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException | ExecutionException | TimeoutException e) {
                logger.warn("Condition check interrupted with '{}'", (Object)e.getClass().getSimpleName());
            }
            finally {
                executor.shutdownNow();
            }
            if (Boolean.TRUE.equals(conditionSatisfied)) {
                logger.info(this.condition.getSuccessMessage(context));
                return;
            }
            long sleepTime = intervalMs - (System.currentTimeMillis() - checkStartTime);
            if (sleepTime <= 0L) continue;
            try {
                Thread.sleep(sleepTime);
            }
            catch (InterruptedException e) {
                logger.warn("Interrupted during wait!", (Throwable)e);
            }
        }
        throw new CitrusRuntimeException(this.condition.getErrorMessage(context));
    }

    private long getWaitTimeMs(TestContext context) {
        return Long.parseLong(context.replaceDynamicContentInString(this.time));
    }

    private long getIntervalMs(TestContext context) {
        return Long.parseLong(context.replaceDynamicContentInString(this.interval));
    }

    public String getTime() {
        return this.time;
    }

    public Condition getCondition() {
        return this.condition;
    }

    public String getInterval() {
        return this.interval;
    }

    public static class Builder<C extends Condition>
    extends AbstractTestActionBuilder<Wait, Builder<C>>
    implements TestActionBuilder.DelegatingTestActionBuilder<Wait> {
        protected C condition;
        protected String time = "5000";
        protected String interval = "1000";
        protected TestActionBuilder<?> delegate;

        public static Builder<Condition> waitFor() {
            return new Builder<Condition>();
        }

        public Builder<C> condition(C condition) {
            this.condition = condition;
            this.delegate = this;
            return this;
        }

        public <T extends WaitConditionBuilder<C, T>> T condition(T conditionBuilder) {
            this.condition = conditionBuilder.getCondition();
            this.delegate = conditionBuilder;
            return conditionBuilder;
        }

        public WaitMessageConditionBuilder message() {
            WaitMessageConditionBuilder builder;
            this.condition = new MessageCondition();
            this.delegate = builder = new WaitMessageConditionBuilder(this);
            return builder;
        }

        public WaitActionConditionBuilder execution() {
            WaitActionConditionBuilder builder;
            this.condition = new ActionCondition();
            this.delegate = builder = new WaitActionConditionBuilder(this);
            return builder;
        }

        public WaitHttpConditionBuilder http() {
            WaitHttpConditionBuilder builder;
            this.condition = new HttpCondition();
            this.delegate = builder = new WaitHttpConditionBuilder(this);
            return builder;
        }

        public WaitFileConditionBuilder file() {
            WaitFileConditionBuilder builder;
            this.condition = new FileCondition();
            this.delegate = builder = new WaitFileConditionBuilder(this);
            return builder;
        }

        public Builder<C> interval(Long interval) {
            return this.interval(String.valueOf(interval));
        }

        public Builder<C> interval(String interval) {
            this.interval = interval;
            return this;
        }

        public Builder<C> milliseconds(long milliseconds) {
            return this.milliseconds(String.valueOf(milliseconds));
        }

        public Builder<C> milliseconds(String milliseconds) {
            this.time = milliseconds;
            return this;
        }

        public Builder<C> seconds(double seconds) {
            this.milliseconds(Math.round(seconds * 1000.0));
            return this;
        }

        public Builder<C> time(Duration duration) {
            this.milliseconds(duration.toMillis());
            return this;
        }

        public Wait build() {
            return new Wait(this);
        }

        public TestActionBuilder<?> getDelegate() {
            return this.delegate;
        }

        public C getCondition() {
            return this.condition;
        }
    }
}

