/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.endpoint.direct;

import java.util.Map;
import org.citrusframework.context.TestContext;
import org.citrusframework.endpoint.AbstractEndpointComponent;
import org.citrusframework.endpoint.Endpoint;
import org.citrusframework.endpoint.EndpointConfiguration;
import org.citrusframework.endpoint.direct.DirectEndpoint;
import org.citrusframework.endpoint.direct.DirectSyncEndpoint;
import org.citrusframework.endpoint.direct.DirectSyncEndpointConfiguration;
import org.citrusframework.message.DefaultMessageQueue;

public class DirectEndpointComponent
extends AbstractEndpointComponent {
    public DirectEndpointComponent() {
        super("direct");
    }

    @Override
    protected Endpoint createEndpoint(String resourcePath, Map<String, String> parameters, TestContext context) {
        String queueName;
        DirectEndpoint endpoint;
        if (resourcePath.startsWith("sync:")) {
            DirectSyncEndpointConfiguration endpointConfiguration = new DirectSyncEndpointConfiguration();
            endpoint = new DirectSyncEndpoint(endpointConfiguration);
            queueName = parameters.getOrDefault("queueName", resourcePath.substring("sync:".length()));
        } else {
            endpoint = new DirectEndpoint();
            queueName = parameters.getOrDefault("queueName", resourcePath);
        }
        endpoint.getEndpointConfiguration().setQueueName(queueName);
        if (!context.getReferenceResolver().isResolvable(queueName)) {
            context.getReferenceResolver().bind(queueName, (Object)new DefaultMessageQueue(queueName));
        }
        this.enrichEndpointConfiguration((EndpointConfiguration)endpoint.getEndpointConfiguration(), parameters, context);
        return endpoint;
    }
}

