/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.log;

import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.citrusframework.CitrusSettings;
import org.citrusframework.log.LogMessageModifier;

public class DefaultLogModifier
implements LogMessageModifier {
    private final Set<String> keywords = CitrusSettings.getLogMaskKeywords();
    private final String logMaskValue = CitrusSettings.getLogMaskValue();
    private boolean maskXml = true;
    private boolean maskJson = true;
    private boolean maskKeyValue = true;
    private boolean maskFormUrlEncoded = true;
    private Pattern keyValuePattern;
    private Pattern xmlPattern;
    private Pattern jsonPattern;
    private Pattern formUrlEncodedPattern;

    public String mask(String source) {
        if (!CitrusSettings.isLogModifierEnabled() || source == null || source.isEmpty()) {
            return source;
        }
        boolean xml = this.maskXml && source.startsWith("<");
        boolean json = this.maskJson && !xml && (source.startsWith("{") || source.startsWith("["));
        boolean formUrlEncoded = this.maskFormUrlEncoded && !json && source.contains("&") && source.contains("=");
        String masked = source;
        if (xml) {
            masked = this.createXmlPattern(this.keywords).matcher(masked).replaceAll("$1" + this.logMaskValue + "$2");
            if (this.maskKeyValue) {
                masked = this.createKeyValuePattern(this.keywords).matcher(masked).replaceAll("$1" + this.logMaskValue);
            }
        } else if (json) {
            masked = this.createJsonPattern(this.keywords).matcher(masked).replaceAll("$1\"" + this.logMaskValue + "\"");
        } else if (formUrlEncoded) {
            masked = this.createFormUrlEncodedPattern(this.keywords).matcher(masked).replaceAll("$1" + this.logMaskValue);
        } else if (this.maskKeyValue) {
            masked = this.createKeyValuePattern(this.keywords).matcher(masked).replaceAll("$1" + this.logMaskValue);
        }
        return masked;
    }

    protected Pattern createKeyValuePattern(Set<String> keywords) {
        if (this.keyValuePattern == null) {
            String keywordExpression = this.createKeywordsExpression(keywords);
            if (keywordExpression.isEmpty()) {
                return null;
            }
            String regex = "((?>" + keywordExpression + ")\\s*=\\s*['\"]?)([^,'\"]+)";
            this.keyValuePattern = Pattern.compile(regex, 2);
        }
        return this.keyValuePattern;
    }

    protected Pattern createFormUrlEncodedPattern(Set<String> keywords) {
        if (this.formUrlEncodedPattern == null) {
            String keywordExpression = this.createKeywordsExpression(keywords);
            if (keywordExpression.isEmpty()) {
                return null;
            }
            String regex = "((?>" + keywordExpression + ")\\s*=\\s*)([^&]*)";
            this.formUrlEncodedPattern = Pattern.compile(regex, 2);
        }
        return this.formUrlEncodedPattern;
    }

    protected Pattern createXmlPattern(Set<String> keywords) {
        if (this.xmlPattern == null) {
            String keywordExpression = this.createKeywordsExpression(keywords);
            if (keywordExpression.isEmpty()) {
                return null;
            }
            String regex = "(<(?>" + keywordExpression + ")>)[^<]*(</(?>" + keywordExpression + ")>)";
            this.xmlPattern = Pattern.compile(regex, 2);
        }
        return this.xmlPattern;
    }

    protected Pattern createJsonPattern(Set<String> keywords) {
        if (this.jsonPattern == null) {
            String keywordExpression = this.createKeywordsExpression(keywords);
            if (keywordExpression.isEmpty()) {
                return null;
            }
            String regex = "(\"(?>" + keywordExpression + ")\"\\s*:\\s*)(\"?[^\",]*[\",])";
            this.jsonPattern = Pattern.compile(regex, 2);
        }
        return this.jsonPattern;
    }

    protected String createKeywordsExpression(Set<String> keywords) {
        if (keywords == null || keywords.isEmpty()) {
            return "";
        }
        return keywords.stream().map(Pattern::quote).collect(Collectors.joining("|"));
    }

    public void setMaskJson(boolean maskJson) {
        this.maskJson = maskJson;
    }

    public void setMaskXml(boolean maskXml) {
        this.maskXml = maskXml;
    }

    public void setMaskKeyValue(boolean maskKeyValue) {
        this.maskKeyValue = maskKeyValue;
    }
}

