/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.main.scan;

import java.util.Arrays;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.citrusframework.main.scan.TestScanner;

public abstract class AbstractTestScanner
implements TestScanner {
    private final String[] includes;
    private final Set<Pattern> includePatterns;

    public AbstractTestScanner(String ... includes) {
        this.includes = includes.length > 0 ? includes : new String[]{"^.*IT$", "^.*ITCase$", "^IT.*$"};
        this.includePatterns = Arrays.stream(includes).map(Pattern::compile).collect(Collectors.toSet());
    }

    protected boolean isIncluded(String className) {
        return ((Stream)this.getIncludePatterns().stream().parallel()).anyMatch(pattern -> pattern.matcher(className).matches());
    }

    public String[] getIncludes() {
        return this.includes;
    }

    public Set<Pattern> getIncludePatterns() {
        return this.includePatterns;
    }
}

