/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.message.correlation;

import org.citrusframework.context.TestContext;
import org.citrusframework.endpoint.PollableEndpointConfiguration;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.message.correlation.DefaultCorrelationManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PollingCorrelationManager<T>
extends DefaultCorrelationManager<T> {
    private final String retryLogMessage;
    private final PollableEndpointConfiguration endpointConfiguration;
    private static final Logger logger = LoggerFactory.getLogger(PollingCorrelationManager.class);
    private static final Logger RETRY_LOG = LoggerFactory.getLogger((String)"org.citrusframework.RetryLogger");

    public PollingCorrelationManager(PollableEndpointConfiguration endpointConfiguration, String retryLogMessage) {
        this.retryLogMessage = retryLogMessage;
        this.endpointConfiguration = endpointConfiguration;
    }

    public T find(String correlationKey) {
        return this.find(correlationKey, this.endpointConfiguration.getTimeout());
    }

    @Override
    public String getCorrelationKey(String correlationKeyName, TestContext context) {
        logger.debug("Get correlation key for '{}'", (Object)correlationKeyName);
        String correlationKey = null;
        if (context.getVariables().containsKey(correlationKeyName)) {
            correlationKey = context.getVariable(correlationKeyName);
        }
        long timeLeft = 1000L;
        long pollingInterval = 300L;
        while (correlationKey == null && timeLeft > 0L) {
            timeLeft -= pollingInterval;
            if (RETRY_LOG.isDebugEnabled()) {
                RETRY_LOG.debug("Correlation key not available yet - retrying in {}ms", (Object)(timeLeft > 0L ? pollingInterval : pollingInterval + timeLeft));
            }
            try {
                Thread.sleep(timeLeft > 0L ? pollingInterval : pollingInterval + timeLeft);
            }
            catch (InterruptedException e) {
                RETRY_LOG.warn("Thread interrupted while waiting for retry", (Throwable)e);
            }
            if (!context.getVariables().containsKey(correlationKeyName)) continue;
            correlationKey = context.getVariable(correlationKeyName);
        }
        if (correlationKey == null) {
            throw new CitrusRuntimeException(String.format("Failed to get correlation key for '%s'", correlationKeyName));
        }
        return correlationKey;
    }

    @Override
    public T find(String correlationKey, long timeout) {
        long timeLeft = timeout;
        long pollingInterval = this.endpointConfiguration.getPollingInterval();
        Object stored = super.find(correlationKey, timeLeft);
        while (stored == null && timeLeft > 0L) {
            timeLeft -= pollingInterval;
            if (RETRY_LOG.isDebugEnabled()) {
                RETRY_LOG.debug("{} - retrying in {}ms", (Object)this.retryLogMessage, (Object)(timeLeft > 0L ? pollingInterval : pollingInterval + timeLeft));
            }
            try {
                Thread.sleep(timeLeft > 0L ? pollingInterval : pollingInterval + timeLeft);
            }
            catch (InterruptedException e) {
                RETRY_LOG.warn("Thread interrupted while waiting for retry", (Throwable)e);
            }
            stored = super.find(correlationKey, timeLeft);
        }
        return stored;
    }

    public String getRetryLogMessage() {
        return this.retryLogMessage;
    }
}

