/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.report;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.citrusframework.CitrusSettings;
import org.citrusframework.TestCase;
import org.citrusframework.context.TestContext;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.message.Message;
import org.citrusframework.message.RawMessage;
import org.citrusframework.report.AbstractTestListener;
import org.citrusframework.report.MessageListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageTracingTestListener
extends AbstractTestListener
implements MessageListener {
    private static final String TRACE_FILE_ENDING = ".msgs";
    private static final Date TEST_EXECUTION_DATE = new Date();
    private String outputDirectory = CitrusSettings.getMessageTraceDirectory();
    private final List<String> messages = new ArrayList<String>();
    private final Object lockObject = new Object();
    private static final Logger logger = LoggerFactory.getLogger(MessageTracingTestListener.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onTestStart(TestCase test) {
        Object object = this.lockObject;
        synchronized (object) {
            this.messages.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onTestExecutionEnd(TestCase test) {
        if (this.messages.isEmpty()) {
            return;
        }
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(this.getTraceFile(test.getName())));){
            writer.write(this.separator() + this.newLine() + this.newLine());
            Object object = this.lockObject;
            synchronized (object) {
                for (String message : this.messages) {
                    writer.write(message);
                    writer.write(this.newLine() + this.separator() + this.newLine() + this.newLine());
                }
            }
            writer.flush();
        }
        catch (IOException e) {
            throw new CitrusRuntimeException("Failed to write message trace to filesystem", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onInboundMessage(Message message, TestContext context) {
        if (message instanceof RawMessage) {
            Object object = this.lockObject;
            synchronized (object) {
                this.messages.add("INBOUND_MESSAGE:" + this.newLine() + this.newLine() + message.print(context));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onOutboundMessage(Message message, TestContext context) {
        if (message instanceof RawMessage) {
            Object object = this.lockObject;
            synchronized (object) {
                this.messages.add("OUTBOUND_MESSAGE:" + this.newLine() + this.newLine() + message.print(context));
            }
        }
    }

    private String separator() {
        return "======================================================================";
    }

    private String newLine() {
        return System.lineSeparator();
    }

    protected File getTraceFile(String testName) {
        File targetDirectory = new File(this.outputDirectory);
        if (!targetDirectory.exists() && !targetDirectory.mkdirs()) {
            throw new CitrusRuntimeException("Unable to create message tracing output directory: " + this.outputDirectory);
        }
        String testExecutionStartTime = new SimpleDateFormat("yyyyMMdd_HHmmss").format(TEST_EXECUTION_DATE);
        String filename = String.format("%s_%s%s", testName, testExecutionStartTime, TRACE_FILE_ENDING);
        File traceFile = new File(targetDirectory, filename);
        if (traceFile.exists()) {
            logger.warn("Trace file '{}' already exists. Normally a new file is created on each test execution ", (Object)traceFile.getName());
        }
        return traceFile;
    }

    public void setOutputDirectory(String outputDirectory) {
        this.outputDirectory = outputDirectory;
    }
}

