/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.sharding;

import java.util.Optional;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.util.SystemProvider;

public final class ShardingConfiguration {
    public static final String TOTAL_SHARD_NUMBER_PROPERTY_NAME = "citrus.sharding.total";
    public static final String TOTAL_SHARD_NUMBER_ENV_VAR_NAME = "citrus.sharding.total".replace(".", "_").toUpperCase();
    public static final String SHARD_NUMBER_PROPERTY_NAME = "citrus.sharding.number";
    public static final String SHARD_NUMBER_ENV_VAR_NAME = "citrus.sharding.number".replace(".", "_").toUpperCase();
    public static final String SHARD_SEED_PROPERTY_NAME = "citrus.sharding.seed";
    public static final String SHARD_SEED_ENV_VAR_NAME = "citrus.sharding.seed".replace(".", "_").toUpperCase();
    private final int totalNumberOfShards;
    private final int shardNumber;
    private final String seed;

    public ShardingConfiguration() {
        this(new SystemProvider());
    }

    ShardingConfiguration(SystemProvider systemProvider) {
        this(ShardingConfiguration.getTotalNumberOfShards(systemProvider), ShardingConfiguration.getShardNumber(systemProvider), systemProvider);
    }

    public ShardingConfiguration(int totalNumberOfShards, int shardNumber) {
        this(totalNumberOfShards, shardNumber, new SystemProvider());
    }

    private ShardingConfiguration(int totalNumberOfShards, int shardNumber, SystemProvider systemProvider) {
        this.totalNumberOfShards = totalNumberOfShards;
        this.shardNumber = shardNumber;
        this.seed = ShardingConfiguration.getSeedOrDefaultValue(systemProvider, totalNumberOfShards);
        this.sanitizeConfiguration();
    }

    private static int getTotalNumberOfShards(SystemProvider systemProvider) {
        return ShardingConfiguration.extractEnvOrProperty(systemProvider, TOTAL_SHARD_NUMBER_ENV_VAR_NAME, TOTAL_SHARD_NUMBER_PROPERTY_NAME, 1, "Failed to calculate number of total shards, received string instead of number!");
    }

    private static int getShardNumber(SystemProvider systemProvider) {
        return ShardingConfiguration.extractEnvOrProperty(systemProvider, SHARD_NUMBER_ENV_VAR_NAME, SHARD_NUMBER_PROPERTY_NAME, 0, "Failed to calculate shard number, received string instead of number!");
    }

    private static String getSeedOrDefaultValue(SystemProvider systemProvider, int totalNumberOfShards) {
        return ShardingConfiguration.extractEnvOrProperty(systemProvider, SHARD_SEED_ENV_VAR_NAME, SHARD_SEED_PROPERTY_NAME).orElseGet(() -> String.valueOf(totalNumberOfShards));
    }

    private static int extractEnvOrProperty(SystemProvider systemProvider, String envVarName, String fallbackPropertyName, int defaultValue, String numberParseErrorMessage) {
        try {
            return Integer.parseInt(ShardingConfiguration.extractEnvOrProperty(systemProvider, envVarName, fallbackPropertyName).orElseGet(() -> String.valueOf(defaultValue)));
        }
        catch (NumberFormatException e) {
            throw new CitrusRuntimeException(numberParseErrorMessage, (Throwable)e);
        }
    }

    private static Optional<String> extractEnvOrProperty(SystemProvider systemProvider, String envVarName, String fallbackPropertyName) {
        return systemProvider.getEnv(envVarName).or(() -> systemProvider.getProperty(fallbackPropertyName));
    }

    private void sanitizeConfiguration() {
        if (this.totalNumberOfShards <= 0) {
            throw new CitrusRuntimeException("Number of total shards must be configured!");
        }
        if (this.shardNumber < 0) {
            throw new CitrusRuntimeException("Shard number cannot be negative!");
        }
        if (this.shardNumber >= this.totalNumberOfShards) {
            throw new CitrusRuntimeException("Shard number must be less than the total number of shards!");
        }
    }

    public int getTotalNumberOfShards() {
        return this.totalNumberOfShards;
    }

    public int getShardNumber() {
        return this.shardNumber;
    }

    public int getSeed() {
        return this.seed.hashCode();
    }
}

