/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.util;

import org.citrusframework.util.SystemProvider;

public class EnvUtils {
    private EnvUtils() {
    }

    public static String transformPropertyToEnv(String property) {
        return property.replace(".", "_").toUpperCase();
    }

    public static boolean booleanPropertyOrDefault(SystemProvider systemProvider, String propertyName, String envName, boolean defaultValue) {
        return Boolean.parseBoolean(systemProvider.getProperty(propertyName).orElseGet(() -> systemProvider.getEnv(envName).orElseGet(() -> Boolean.toString(defaultValue))));
    }

    public static <T extends Enum<T>> T enumPropertyOrDefault(SystemProvider systemProvider, Class<T> enumClass, String propertyName, String envName, T defaultValue) {
        return Enum.valueOf(enumClass, systemProvider.getProperty(propertyName).orElseGet(() -> systemProvider.getEnv(envName).orElseGet(defaultValue::name)));
    }
}

