/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.validation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.citrusframework.context.TestContext;
import org.citrusframework.exceptions.ValidationException;
import org.citrusframework.util.StringUtils;
import org.citrusframework.validation.HeaderValidator;
import org.citrusframework.validation.context.HeaderValidationContext;
import org.citrusframework.validation.context.ValidationStatus;
import org.citrusframework.validation.matcher.ValidationMatcherUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultHeaderValidator
implements HeaderValidator {
    private static final Logger logger = LoggerFactory.getLogger(DefaultHeaderValidator.class);
    private static final Map<String, HeaderValidator> DEFAULT_VALIDATORS = HeaderValidator.lookup();

    public void validateHeader(String headerName, Object receivedValue, Object controlValue, TestContext context, HeaderValidationContext validationContext) {
        Optional<HeaderValidator> validator = DefaultHeaderValidator.getHeaderValidator(headerName, controlValue, context);
        if (validator.isPresent()) {
            try {
                validator.get().validateHeader(headerName, receivedValue, controlValue, context, validationContext);
                validationContext.updateStatus(ValidationStatus.PASSED);
            }
            catch (ValidationException e) {
                validationContext.updateStatus(ValidationStatus.FAILED);
                throw e;
            }
            return;
        }
        try {
            String expectedValue = Optional.ofNullable(controlValue).map(value -> (String)context.getTypeConverter().convertIfNecessary(value, String.class)).map(arg_0 -> ((TestContext)context).replaceDynamicContentInString(arg_0)).orElse("");
            if (receivedValue != null) {
                String receivedValueString = (String)context.getTypeConverter().convertIfNecessary(receivedValue, String.class);
                if (ValidationMatcherUtils.isValidationMatcherExpression((String)expectedValue)) {
                    ValidationMatcherUtils.resolveValidationMatcher((String)headerName, (String)receivedValueString, (String)expectedValue, (TestContext)context);
                    return;
                }
                if (!receivedValueString.equals(expectedValue)) {
                    throw new ValidationException("Values not equal for header element '" + headerName + "', expected '" + expectedValue + "' but was '" + receivedValue + "'");
                }
            } else if (StringUtils.hasText(expectedValue)) {
                throw new ValidationException("Values not equal for header element '" + headerName + "', expected '" + expectedValue + "' but was 'null'");
            }
            logger.debug("Validating header element: {}='{}' : OK", (Object)headerName, (Object)expectedValue);
            validationContext.updateStatus(ValidationStatus.PASSED);
        }
        catch (ValidationException e) {
            validationContext.updateStatus(ValidationStatus.FAILED);
            throw e;
        }
    }

    public void validateHeaderArray(String headerName, Object receivedValue, Object controlValue, TestContext context, HeaderValidationContext validationContext) {
        Optional<HeaderValidator> validator = DefaultHeaderValidator.getHeaderValidator(headerName, controlValue, context);
        if (validator.isPresent()) {
            try {
                validator.get().validateHeader(headerName, receivedValue, controlValue, context, validationContext);
                validationContext.updateStatus(ValidationStatus.PASSED);
            }
            catch (ValidationException e) {
                validationContext.updateStatus(ValidationStatus.FAILED);
                throw e;
            }
            return;
        }
        try {
            List<String> receivedValues = DefaultHeaderValidator.toList(receivedValue);
            List<String> controlValues = DefaultHeaderValidator.toList(controlValue);
            List<String> expectedValues = controlValues.stream().map(value -> (String)context.getTypeConverter().convertIfNecessary(value, String.class)).map(arg_0 -> ((TestContext)context).replaceDynamicContentInString(arg_0)).toList();
            if (receivedValue != null) {
                List<String> receivedValueStrings = receivedValues.stream().map(value -> (String)context.getTypeConverter().convertIfNecessary(value, String.class)).toList();
                ArrayList<String> expectedValuesCopy = new ArrayList<String>(expectedValues);
                for (String receivedValueString : receivedValueStrings) {
                    Iterator<String> expectedIterator;
                    boolean validated = DefaultHeaderValidator.validateExpected(headerName, context, receivedValueString, expectedIterator = expectedValuesCopy.iterator());
                    if (validated) continue;
                    throw new ValidationException(String.format("Values not equal for header element '%s', expected '%s' but was '%s'", headerName, String.join((CharSequence)", ", expectedValues), receivedValueString));
                }
                if (!expectedValuesCopy.isEmpty()) {
                    throw new ValidationException(String.format("Values not equal for header element '%s', expected '%s' but was '%s'", headerName, String.join((CharSequence)", ", expectedValues), String.join((CharSequence)", ", receivedValues)));
                }
            } else if (!expectedValues.isEmpty()) {
                throw new ValidationException(String.format("Values not equal for header element '%s', expected '%s' but was 'null'", headerName, String.join((CharSequence)", ", expectedValues)));
            }
            logger.debug("Validating header element: {}='{}' : OK", (Object)headerName, (Object)String.join((CharSequence)", ", expectedValues));
            validationContext.updateStatus(ValidationStatus.PASSED);
        }
        catch (ValidationException e) {
            validationContext.updateStatus(ValidationStatus.FAILED);
            throw e;
        }
    }

    private static boolean validateExpected(String headerName, TestContext context, String receivedValueString, Iterator<String> expectedIterator) {
        boolean validated = false;
        while (expectedIterator.hasNext()) {
            String expectedValue = expectedIterator.next();
            if (ValidationMatcherUtils.isValidationMatcherExpression((String)expectedValue)) {
                try {
                    ValidationMatcherUtils.resolveValidationMatcher((String)headerName, (String)receivedValueString, (String)expectedValue, (TestContext)context);
                    validated = true;
                    expectedIterator.remove();
                    break;
                }
                catch (ValidationException validationException) {
                    continue;
                }
            }
            if (!receivedValueString.equals(expectedValue)) continue;
            validated = true;
            expectedIterator.remove();
            break;
        }
        return validated;
    }

    private static List<String> toList(Object value) {
        ArrayList<String> receivedValuesList;
        if (value == null) {
            receivedValuesList = Collections.emptyList();
        } else if (!(value instanceof List)) {
            receivedValuesList = new ArrayList<String>();
            receivedValuesList.add(value.toString());
        } else {
            receivedValuesList = (ArrayList<String>)value;
        }
        return receivedValuesList;
    }

    public boolean supports(String headerName, Class<?> type) {
        return type == null || type.isInstance(String.class) || type.isPrimitive();
    }

    private static Optional<HeaderValidator> getHeaderValidator(String headerName, Object controlValue, TestContext context) {
        HashMap<String, HeaderValidator> allValidators = new HashMap<String, HeaderValidator>(DEFAULT_VALIDATORS);
        allValidators.putAll(context.getReferenceResolver().resolveAll(HeaderValidator.class));
        return allValidators.values().stream().filter(validator -> !(validator instanceof DefaultHeaderValidator)).filter(validator -> validator.supports(headerName, (Class)Optional.ofNullable(controlValue).map(Object::getClass).orElse(null))).findFirst();
    }
}

