/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.validation.script;

import java.io.IOException;
import java.nio.charset.Charset;
import org.citrusframework.CitrusSettings;
import org.citrusframework.context.TestContext;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.spi.Resource;
import org.citrusframework.util.FileUtils;
import org.citrusframework.validation.context.DefaultValidationContext;
import org.citrusframework.validation.context.ValidationContext;

public class ScriptValidationContext
extends DefaultValidationContext {
    private final String validationScriptResourcePath;
    private final String validationScriptResourceCharset;
    private final String validationScript;
    private final String scriptType;

    public ScriptValidationContext() {
        this(Builder.groovy());
    }

    public ScriptValidationContext(String scriptType) {
        this(new Builder().scriptType(scriptType));
    }

    public ScriptValidationContext(Builder builder) {
        this.validationScript = builder.validationScript;
        this.validationScriptResourcePath = builder.validationScriptResourcePath;
        this.validationScriptResourceCharset = builder.validationScriptResourceCharset;
        this.scriptType = builder.scriptType;
    }

    public boolean requiresValidator() {
        return true;
    }

    public String getValidationScript(TestContext context) {
        try {
            if (this.validationScriptResourcePath != null) {
                return context.replaceDynamicContentInString(FileUtils.readToString(FileUtils.getFileResource(this.validationScriptResourcePath, context), Charset.forName(context.replaceDynamicContentInString(this.validationScriptResourceCharset))));
            }
            if (this.validationScript != null) {
                return context.replaceDynamicContentInString(this.validationScript);
            }
            return "";
        }
        catch (IOException e) {
            throw new CitrusRuntimeException("Failed to load validation script resource", (Throwable)e);
        }
    }

    public String getScriptType() {
        return this.scriptType;
    }

    public String getValidationScriptResourcePath() {
        return this.validationScriptResourcePath;
    }

    public String getValidationScript() {
        return this.validationScript;
    }

    public String getValidationScriptResourceCharset() {
        return this.validationScriptResourceCharset;
    }

    public static final class Builder
    implements ValidationContext.Builder<ScriptValidationContext, Builder> {
        private String validationScriptResourcePath;
        private String validationScriptResourceCharset = CitrusSettings.CITRUS_FILE_ENCODING;
        private String validationScript = "";
        private String scriptType = "groovy";

        public static Builder groovy() {
            return new Builder();
        }

        public Builder script(String validationScript) {
            this.validationScript = validationScript;
            return this;
        }

        public Builder script(Resource scriptResource) {
            return this.script(scriptResource, FileUtils.getDefaultCharset());
        }

        public Builder script(Resource scriptResource, Charset charset) {
            try {
                this.script(FileUtils.readToString(scriptResource, charset));
            }
            catch (IOException e) {
                throw new CitrusRuntimeException("Failed to read script resource file", (Throwable)e);
            }
            return this;
        }

        public Builder scriptResource(String fileResourcePath) {
            this.validationScriptResourcePath = fileResourcePath;
            return this;
        }

        public Builder scriptResourceCharset(String charsetName) {
            this.validationScriptResourceCharset = charsetName;
            return this;
        }

        public Builder scriptType(String type) {
            this.scriptType = type;
            return this;
        }

        public ScriptValidationContext build() {
            return new ScriptValidationContext(this);
        }
    }
}

