/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.validation.xml;

import java.util.HashMap;
import java.util.Map;
import org.citrusframework.validation.context.DefaultMessageValidationContext;
import org.citrusframework.validation.context.MessageValidationContext;
import org.citrusframework.validation.context.ValidationStatus;
import org.citrusframework.validation.xml.XmlNamespaceAware;
import org.citrusframework.validation.xml.XpathMessageValidationContext;

public class XmlMessageValidationContext
extends DefaultMessageValidationContext {
    private final MessageValidationContext delegate;
    private final Map<String, String> namespaces;
    private final Map<String, String> controlNamespaces;

    public XmlMessageValidationContext() {
        this(new Builder());
    }

    public XmlMessageValidationContext(XmlValidationContextBuilder<?, ?> builder) {
        super(builder);
        this.delegate = builder.delegate;
        this.namespaces = builder.namespaces;
        this.controlNamespaces = builder.controlNamespaces;
    }

    public void updateStatus(ValidationStatus status) {
        super.updateStatus(status);
        if (this.delegate != null) {
            this.delegate.updateStatus(status);
        }
    }

    public Map<String, String> getNamespaces() {
        return this.namespaces;
    }

    public Map<String, String> getControlNamespaces() {
        return this.controlNamespaces;
    }

    public static final class Builder
    extends XmlValidationContextBuilder<XmlMessageValidationContext, Builder> {
        public static Builder xml() {
            return new Builder();
        }

        public static Builder adapt(MessageValidationContext.Builder<?, ?> messageValidationContext) {
            return Builder.adapt((MessageValidationContext)messageValidationContext.build());
        }

        public static Builder adapt(MessageValidationContext messageValidationContext) {
            Builder builder = new Builder();
            builder.ignore(messageValidationContext.getIgnoreExpressions());
            builder.schemaValidation(messageValidationContext.isSchemaValidationEnabled());
            builder.schema(messageValidationContext.getSchema());
            builder.schemaRepository(messageValidationContext.getSchemaRepository());
            builder.delegate(messageValidationContext);
            return builder;
        }

        public XpathMessageValidationContext.Builder expressions() {
            return new XpathMessageValidationContext.Builder();
        }

        public XpathMessageValidationContext.Builder expression(String path, Object expectedValue) {
            return new XpathMessageValidationContext.Builder().expression(path, expectedValue);
        }

        public XpathMessageValidationContext.Builder xpath() {
            return (XpathMessageValidationContext.Builder)((XpathMessageValidationContext.Builder)((XpathMessageValidationContext.Builder)((XpathMessageValidationContext.Builder)((XpathMessageValidationContext.Builder)((Object)((XpathMessageValidationContext.Builder)((Object)new XpathMessageValidationContext.Builder().namespaceContext(this.namespaces))).namespaces(this.controlNamespaces))).schemaValidation(this.schemaValidation)).schemaRepository(this.schemaRepository)).schema(this.schema)).ignore(this.ignoreExpressions);
        }

        public XmlMessageValidationContext build() {
            return new XmlMessageValidationContext(this);
        }
    }

    public static abstract class XmlValidationContextBuilder<T extends XmlMessageValidationContext, S extends XmlValidationContextBuilder<T, S>>
    extends MessageValidationContext.Builder<T, S>
    implements XmlNamespaceAware {
        protected final S self;
        protected MessageValidationContext delegate;
        protected Map<String, String> namespaces = new HashMap<String, String>();
        protected final Map<String, String> controlNamespaces = new HashMap<String, String>();

        protected XmlValidationContextBuilder() {
            this.self = this;
        }

        public S namespace(String prefix, String namespaceUri) {
            this.controlNamespaces.put(prefix, namespaceUri);
            return this.self;
        }

        public S namespaces(Map<String, String> namespaces) {
            this.controlNamespaces.putAll(namespaces);
            return this.self;
        }

        public S namespaceContext(String prefix, String namespaceUri) {
            this.namespaces.put(prefix, namespaceUri);
            return this.self;
        }

        public S namespaceContext(Map<String, String> namespaces) {
            this.namespaces.putAll(namespaces);
            return this.self;
        }

        public void setNamespaces(Map<String, String> namespaces) {
            this.namespaces = namespaces;
        }

        protected S delegate(MessageValidationContext delegate) {
            this.delegate = delegate;
            return this.self;
        }
    }
}

