/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.actions;

import java.util.LinkedHashMap;
import java.util.Map;
import org.citrusframework.AbstractTestActionBuilder;
import org.citrusframework.actions.AbstractTestAction;
import org.citrusframework.actions.CreateVariablesActionBuilder;
import org.citrusframework.context.TestContext;
import org.citrusframework.variable.VariableUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateVariablesAction
extends AbstractTestAction {
    private final Map<String, Object> variables;
    private static final Logger logger = LoggerFactory.getLogger(CreateVariablesAction.class);

    private CreateVariablesAction(Builder builder) {
        super("create-variables", builder);
        this.variables = builder.variables;
    }

    @Override
    public void doExecute(TestContext context) {
        for (Map.Entry<String, Object> entry : this.variables.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (value instanceof String) {
                String stringValue = (String)value;
                if (stringValue.startsWith("script:<")) {
                    String scriptEngine = stringValue.substring("script:<".length(), stringValue.indexOf(62));
                    stringValue = VariableUtils.getValueFromScript((String)scriptEngine, (String)context.replaceDynamicContentInString(stringValue.substring(stringValue.indexOf(62) + 1)));
                }
                value = context.replaceDynamicContentInString(stringValue);
            }
            logger.info("Setting variable: {} to value: {}", (Object)key, value);
            context.setVariable(key, value);
        }
    }

    public Map<String, Object> getVariables() {
        return this.variables;
    }

    public static final class Builder
    extends AbstractTestActionBuilder<CreateVariablesAction, Builder>
    implements CreateVariablesActionBuilder<CreateVariablesAction> {
        private final Map<String, Object> variables = new LinkedHashMap<String, Object>();

        public static Builder createVariable(String variableName, Object value) {
            Builder builder = new Builder();
            builder.variable(variableName, value);
            return builder;
        }

        public static Builder createVariables() {
            return new Builder();
        }

        public Builder variable(String variableName, Object value) {
            this.variables.put(variableName, value);
            return this;
        }

        public CreateVariablesAction build() {
            return new CreateVariablesAction(this);
        }
    }
}

