/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.actions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.citrusframework.CitrusSettings;
import org.citrusframework.TestAction;
import org.citrusframework.actions.AbstractTestAction;
import org.citrusframework.actions.ReceiveActionBuilder;
import org.citrusframework.context.TestContext;
import org.citrusframework.endpoint.Endpoint;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.exceptions.ValidationException;
import org.citrusframework.message.Message;
import org.citrusframework.message.MessageBuilder;
import org.citrusframework.message.MessageDirection;
import org.citrusframework.message.MessagePayload;
import org.citrusframework.message.MessagePayloadBuilder;
import org.citrusframework.message.MessagePayloadUtils;
import org.citrusframework.message.MessageProcessor;
import org.citrusframework.message.MessageSelectorBuilder;
import org.citrusframework.message.MessageType;
import org.citrusframework.message.WithPayloadBuilder;
import org.citrusframework.message.builder.DefaultPayloadBuilder;
import org.citrusframework.message.builder.FileResourcePayloadBuilder;
import org.citrusframework.message.builder.MessageBuilderSupport;
import org.citrusframework.message.builder.ReceiveMessageBuilderSupport;
import org.citrusframework.messaging.Consumer;
import org.citrusframework.messaging.SelectiveConsumer;
import org.citrusframework.spi.ReferenceResolverAware;
import org.citrusframework.util.FileUtils;
import org.citrusframework.util.StringUtils;
import org.citrusframework.util.TypeConverter;
import org.citrusframework.validation.DefaultMessageHeaderValidator;
import org.citrusframework.validation.HeaderValidator;
import org.citrusframework.validation.MessageValidator;
import org.citrusframework.validation.ValidationContextAdapter;
import org.citrusframework.validation.ValidationProcessor;
import org.citrusframework.validation.builder.StaticMessageBuilder;
import org.citrusframework.validation.context.DefaultMessageValidationContext;
import org.citrusframework.validation.context.HeaderValidationContext;
import org.citrusframework.validation.context.MessageValidationContext;
import org.citrusframework.validation.context.ValidationContext;
import org.citrusframework.validation.context.ValidationStatus;
import org.citrusframework.validation.json.JsonMessageValidationContext;
import org.citrusframework.validation.xml.XmlMessageValidationContext;
import org.citrusframework.validation.yaml.YamlMessageValidationContext;
import org.citrusframework.variable.VariableExtractor;
import org.citrusframework.variable.dictionary.DataDictionary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReceiveMessageAction
extends AbstractTestAction {
    private final Map<String, Object> messageSelectorMap;
    private final String messageSelector;
    private final Endpoint endpoint;
    private final String endpointUri;
    private final long receiveTimeout;
    private final MessageBuilder messageBuilder;
    private final List<MessageValidator<? extends ValidationContext>> validators;
    private final DataDictionary<?> dataDictionary;
    private final ValidationProcessor validationProcessor;
    private final List<ValidationContext> validationContexts;
    private final List<VariableExtractor> variableExtractors;
    private final List<MessageProcessor> messageProcessors;
    private final List<MessageProcessor> controlMessageProcessors;
    private String messageType;
    private static final Logger logger = LoggerFactory.getLogger(ReceiveMessageAction.class);

    public ReceiveMessageAction(ReceiveMessageActionBuilder<?, ?, ?> builder) {
        super("receive", builder);
        this.endpoint = builder.getEndpoint();
        this.endpointUri = builder.getEndpointUri();
        this.receiveTimeout = builder.receiveTimeout;
        this.messageSelector = builder.messageSelector;
        this.messageSelectorMap = builder.messageSelectorMap;
        this.validators = builder.validators;
        this.validationProcessor = builder.validationProcessor;
        this.validationContexts = builder.getValidationContexts();
        this.variableExtractors = builder.getVariableExtractors();
        this.messageProcessors = builder.getMessageProcessors();
        this.messageBuilder = ((ReceiveMessageBuilderSupport)builder.getMessageBuilderSupport()).getMessageBuilder();
        this.dataDictionary = ((ReceiveMessageBuilderSupport)builder.getMessageBuilderSupport()).getDataDictionary();
        this.controlMessageProcessors = ((ReceiveMessageBuilderSupport)builder.getMessageBuilderSupport()).getControlMessageProcessors();
        this.messageType = ((ReceiveMessageBuilderSupport)builder.getMessageBuilderSupport()).getMessageType();
    }

    @Override
    public void doExecute(TestContext context) {
        String selector = MessageSelectorBuilder.build(this.messageSelector, this.messageSelectorMap, context);
        Message receivedMessage = StringUtils.hasText(selector) ? this.receiveSelected(context, selector) : this.receive(context);
        if (receivedMessage == null) {
            throw new CitrusRuntimeException("Failed to receive message - message is not available");
        }
        this.validateMessage(receivedMessage, context);
    }

    private Message receive(TestContext context) {
        Endpoint messageEndpoint = this.getOrCreateEndpoint(context);
        return this.receiveTimeout > 0L ? messageEndpoint.createConsumer().receive(context, this.receiveTimeout) : messageEndpoint.createConsumer().receive(context, messageEndpoint.getEndpointConfiguration().getTimeout());
    }

    private Message receiveSelected(TestContext context, String selectorString) {
        logger.debug("Setting message selector: '{}'", (Object)selectorString);
        Endpoint messageEndpoint = this.getOrCreateEndpoint(context);
        Consumer consumer = messageEndpoint.createConsumer();
        if (consumer instanceof SelectiveConsumer) {
            if (this.receiveTimeout > 0L) {
                return ((SelectiveConsumer)messageEndpoint.createConsumer()).receive(context.replaceDynamicContentInString(selectorString), context, this.receiveTimeout);
            }
            return ((SelectiveConsumer)messageEndpoint.createConsumer()).receive(context.replaceDynamicContentInString(selectorString), context, messageEndpoint.getEndpointConfiguration().getTimeout());
        }
        logger.warn("Unable to receive selective with consumer implementation: '{}'", consumer.getClass());
        return this.receive(context);
    }

    protected void validateMessage(Message message, TestContext context) {
        this.messageProcessors.forEach(processor -> processor.process(message, context));
        logger.debug("Received message:\n{}", (Object)message.print(context));
        for (VariableExtractor variableExtractor : this.variableExtractors) {
            variableExtractor.extractVariables(message, context);
        }
        Message controlMessage = this.createControlMessage(context, this.messageType);
        if (StringUtils.hasText(controlMessage.getName())) {
            context.getMessageStore().storeMessage(controlMessage.getName(), message);
        } else {
            context.getMessageStore().storeMessage(context.getMessageStore().constructMessageName((TestAction)this, this.getOrCreateEndpoint(context)), message);
        }
        if (Objects.nonNull(this.validationProcessor)) {
            this.validationProcessor.validate(message, context);
        } else {
            List<ValidationContext> list;
            logger.debug("Control message:\n{}", (Object)controlMessage.print(context));
            if (StringUtils.hasText((String)controlMessage.getPayload(String.class))) {
                this.assumeMessageType(controlMessage);
            } else {
                this.assumeMessageType(message);
            }
            if (Objects.nonNull(this.validators) && !this.validators.isEmpty()) {
                MessageValidator messageValidator;
                for (MessageValidator<? extends ValidationContext> messageValidator2 : this.validators) {
                    messageValidator2.validateMessage(message, controlMessage, context, this.validationContexts);
                }
                if (this.validators.parallelStream().map(Object::getClass).noneMatch(DefaultMessageHeaderValidator.class::isAssignableFrom) && (messageValidator = context.getMessageValidatorRegistry().getDefaultMessageHeaderValidator()) != null) {
                    messageValidator.validateMessage(message, controlMessage, context, this.validationContexts);
                }
            } else {
                boolean bl = this.validationContexts.stream().anyMatch(ValidationContext::requiresValidator);
                List list2 = context.getMessageValidatorRegistry().findMessageValidators(this.messageType, message, bl);
                for (MessageValidator messageValidator : list2) {
                    messageValidator.validateMessage(message, controlMessage, context, this.validationContexts);
                }
                if (CitrusSettings.isPerformDefaultValidation() && this.validationContexts.stream().anyMatch(validationContext -> validationContext.getStatus() == ValidationStatus.UNKNOWN)) {
                    MessageValidator defaultValidator = context.getMessageValidatorRegistry().getDefaultMessageValidator();
                    if (list2.stream().noneMatch(validator -> defaultValidator.getClass().isInstance(validator))) {
                        defaultValidator.validateMessage(message, controlMessage, context, this.validationContexts);
                    }
                }
            }
            if (!(list = this.validationContexts.stream().filter(validationContext -> validationContext.getStatus() == ValidationStatus.UNKNOWN).toList()).isEmpty()) {
                list.forEach(validationContext -> logger.warn("Found validation context that has not been processed: {}", (Object)validationContext.getClass().getName()));
                throw new ValidationException("Incomplete message validation of message with type %s - no validation has been performed on the following contexts: %s".formatted(this.messageType, list.stream().map(validationContext -> validationContext.getClass().getSimpleName()).collect(Collectors.joining(", "))));
            }
        }
    }

    private void assumeMessageType(Message message) {
        Object encoding;
        String contentTypeString;
        MessageType messageType;
        Object contentType = message.getHeaders().get("Content-Type");
        if (contentType instanceof String && (messageType = MessageType.mapToMessageType((String)(contentTypeString = (String)contentType), (String)((encoding = message.getHeaders().get("Content-Transfer-Encoding")) != null ? encoding.toString() : null))) != null) {
            this.setMessageType(messageType);
            return;
        }
        if (MessageType.isBinary((String)this.getMessageType()) || "x-www-form-urlencoded".equalsIgnoreCase(this.getMessageType())) {
            return;
        }
        if (ReceiveMessageAction.isEffectivelyNullishPayload(message)) {
            this.setMessageType(MessageType.PLAINTEXT);
            return;
        }
        String payload = ((String)message.getPayload(String.class)).trim();
        if (MessagePayloadUtils.isXml((String)payload) && (Objects.isNull(this.getMessageType()) || !MessageType.isXml((String)this.getMessageType()))) {
            logger.warn("Detected XML message payload type, but non-XML message type '{}' configured! Assuming message type {}", (Object)this.getMessageType(), (Object)MessageType.XML);
            this.setMessageType(MessageType.XML);
        } else if (MessagePayloadUtils.isJson((String)payload) && (Objects.isNull(this.getMessageType()) || !this.getMessageType().equalsIgnoreCase(MessageType.JSON.name()))) {
            logger.warn("Detected JSON message payload type, but non-JSON message type '{}' configured! Assuming message type {}", (Object)this.getMessageType(), (Object)MessageType.JSON);
            this.setMessageType(MessageType.JSON);
        } else if (MessagePayloadUtils.isYaml((String)payload) && (Objects.isNull(this.getMessageType()) || !this.getMessageType().equalsIgnoreCase(MessageType.YAML.name()))) {
            logger.warn("Detected YAML message payload type, but non-YAML message type '{}' configured! Assuming message type {}", (Object)this.getMessageType(), (Object)MessageType.YAML);
            this.setMessageType(MessageType.YAML);
        }
    }

    private static boolean isEffectivelyNullishPayload(Message message) {
        String payload = Objects.isNull(message.getPayload()) && "null".equals(message.getPayload(String.class)) ? null : (String)message.getPayload(String.class);
        return !StringUtils.hasText(payload);
    }

    protected Message createControlMessage(TestContext context, String messageType) {
        Message message = this.messageBuilder.build(context, messageType);
        if (message.getPayload() != null) {
            context.getMessageProcessors(MessageDirection.INBOUND).forEach(processor -> processor.process(message, context));
            if (this.dataDictionary != null) {
                this.dataDictionary.process(message, context);
            }
            this.controlMessageProcessors.forEach(processor -> processor.process(message, context));
        }
        return message;
    }

    @Override
    public boolean isDisabled(TestContext context) {
        Endpoint messageEndpoint = this.getOrCreateEndpoint(context);
        if (this.getActor() == null && messageEndpoint.getActor() != null) {
            return messageEndpoint.getActor().isDisabled();
        }
        return super.isDisabled(context);
    }

    public Endpoint getOrCreateEndpoint(TestContext context) {
        if (this.endpoint != null) {
            return this.endpoint;
        }
        if (StringUtils.hasText(this.endpointUri)) {
            return context.getEndpointFactory().create(this.endpointUri, context);
        }
        throw new CitrusRuntimeException("Neither endpoint nor endpoint uri is set properly!");
    }

    public Endpoint getEndpoint() {
        return this.endpoint;
    }

    public String getEndpointUri() {
        return this.endpointUri;
    }

    public List<VariableExtractor> getVariableExtractors() {
        return this.variableExtractors;
    }

    public List<MessageProcessor> getMessageProcessors() {
        return this.messageProcessors;
    }

    public List<MessageProcessor> getControlMessageProcessors() {
        return this.controlMessageProcessors;
    }

    public String getMessageType() {
        return this.messageType;
    }

    private void setMessageType(MessageType messageType) {
        this.messageType = messageType.name();
    }

    public Map<String, Object> getMessageSelectorMap() {
        return this.messageSelectorMap;
    }

    public String getMessageSelector() {
        return this.messageSelector;
    }

    public long getReceiveTimeout() {
        return this.receiveTimeout;
    }

    public List<MessageValidator<? extends ValidationContext>> getValidators() {
        return Collections.unmodifiableList(this.validators);
    }

    public List<ValidationContext> getValidationContexts() {
        return this.validationContexts;
    }

    public ValidationProcessor getValidationProcessor() {
        return this.validationProcessor;
    }

    public DataDictionary<?> getDataDictionary() {
        return this.dataDictionary;
    }

    public MessageBuilder getMessageBuilder() {
        return this.messageBuilder;
    }

    public static abstract class ReceiveMessageActionBuilder<T extends ReceiveMessageAction, M extends ReceiveMessageBuilderSupport<T, B, M>, B extends ReceiveMessageActionBuilder<T, M, B>>
    extends MessageBuilderSupport.MessageActionBuilder<T, M, B>
    implements ReceiveActionBuilder<T, M, B> {
        private long receiveTimeout = 0L;
        private final Map<String, Object> messageSelectorMap = new HashMap<String, Object>();
        private String messageSelector;
        private final List<MessageValidator<? extends ValidationContext>> validators = new ArrayList<MessageValidator<? extends ValidationContext>>();
        private ValidationProcessor validationProcessor;
        private final List<ValidationContext.Builder<?, ?>> validationContexts = new ArrayList();
        private HeaderValidationContext.Builder headerValidationContext;
        private final List<String> validatorNames = new ArrayList<String>();

        public B timeout(long receiveTimeout) {
            this.receiveTimeout = receiveTimeout;
            return (B)((ReceiveMessageActionBuilder)this.self);
        }

        public B validate(ValidationContext.Builder<?, ?> validationContext) {
            this.validationContexts.add(validationContext);
            return (B)((ReceiveMessageActionBuilder)this.self);
        }

        public B validate(ValidationContext validationContext) {
            return (B)this.validate(() -> validationContext);
        }

        public B validate(ValidationContextAdapter adapter) {
            return (B)this.validate(adapter.asValidationContext());
        }

        public B validate(List<ValidationContext.Builder<?, ?>> validationContexts) {
            this.validationContexts.addAll(validationContexts);
            return (B)((ReceiveMessageActionBuilder)this.self);
        }

        public B validate(ValidationContext.Builder<?, ?> ... validationContexts) {
            return (B)this.validate((List)Arrays.asList(validationContexts));
        }

        public B selector(String messageSelector) {
            this.messageSelector = messageSelector;
            return (B)((ReceiveMessageActionBuilder)this.self);
        }

        public B selector(Map<String, String> messageSelector) {
            this.messageSelectorMap.putAll(messageSelector);
            return (B)((ReceiveMessageActionBuilder)this.self);
        }

        public B validator(MessageValidator<? extends ValidationContext> validator) {
            this.validators.add(validator);
            return (B)((ReceiveMessageActionBuilder)this.self);
        }

        public final B validators(String ... validators) {
            Arrays.stream(validators).forEach(string -> this.validator((String)string));
            return (B)((ReceiveMessageActionBuilder)this.self);
        }

        @SafeVarargs
        public final B validators(MessageValidator<? extends ValidationContext> ... validators) {
            return (B)this.validators((List)Arrays.asList(validators));
        }

        public B validators(List<MessageValidator<? extends ValidationContext>> validators) {
            this.validators.addAll(validators);
            return (B)((ReceiveMessageActionBuilder)this.self);
        }

        public final B validators(HeaderValidator ... validators) {
            Stream.of(validators).forEach(headerValidator -> this.validator((HeaderValidator)headerValidator));
            return (B)((ReceiveMessageActionBuilder)this.self);
        }

        public B validator(String validatorName) {
            this.validatorNames.add(validatorName);
            return (B)((ReceiveMessageActionBuilder)this.self);
        }

        public B validator(HeaderValidator validators) {
            Stream.of(validators).forEach(arg_0 -> ((HeaderValidationContext.Builder)this.getHeaderValidationContext()).validator(arg_0));
            return (B)((ReceiveMessageActionBuilder)this.self);
        }

        public B validate(ValidationProcessor processor) {
            this.validationProcessor = processor;
            return (B)((ReceiveMessageActionBuilder)this.self);
        }

        @Override
        public B process(MessageProcessor processor) {
            if (processor instanceof VariableExtractor) {
                VariableExtractor variableExtractor = (VariableExtractor)processor;
                this.variableExtractors.add(variableExtractor);
            } else if (processor instanceof ValidationProcessor) {
                ValidationProcessor validationProcessor = (ValidationProcessor)processor;
                this.validate(validationProcessor);
            } else {
                this.messageProcessors.add(processor);
            }
            return (B)((ReceiveMessageActionBuilder)this.self);
        }

        public final T build() {
            if (this.messageBuilderSupport == null) {
                this.messageBuilderSupport = this.getMessageBuilderSupport();
            }
            this.reconcileValidationContexts();
            this.validationContexts.stream().filter(HeaderValidationContext.Builder.class::isInstance).forEach(c -> ((HeaderValidationContext.Builder)c).ignoreCase(((ReceiveMessageBuilderSupport)this.messageBuilderSupport).isHeaderNameIgnoreCase()));
            if (this.referenceResolver != null) {
                ValidationProcessor validationProcessor = this.validationProcessor;
                if (validationProcessor instanceof ReferenceResolverAware) {
                    ReferenceResolverAware referenceResolverAware = (ReferenceResolverAware)validationProcessor;
                    referenceResolverAware.setReferenceResolver(this.referenceResolver);
                }
                while (!this.validatorNames.isEmpty()) {
                    String validatorName = this.validatorNames.remove(0);
                    Object validator = this.referenceResolver.resolve(validatorName);
                    if (validator instanceof HeaderValidator) {
                        this.getHeaderValidationContext().validator((HeaderValidator)validator);
                        continue;
                    }
                    this.validators.add((MessageValidator<? extends ValidationContext>)((MessageValidator)validator));
                }
                if (((ReceiveMessageBuilderSupport)this.messageBuilderSupport).getDataDictionaryName() != null) {
                    ((ReceiveMessageBuilderSupport)this.messageBuilderSupport).dictionary((DataDictionary)this.referenceResolver.resolve(((ReceiveMessageBuilderSupport)this.messageBuilderSupport).getDataDictionaryName(), DataDictionary.class));
                }
            }
            return (T)((ReceiveMessageAction)this.doBuild());
        }

        public HeaderValidationContext.Builder getHeaderValidationContext() {
            if (this.headerValidationContext == null) {
                this.headerValidationContext = new HeaderValidationContext.Builder();
                this.validate((ValidationContext.Builder)this.headerValidationContext);
            }
            return this.headerValidationContext;
        }

        protected void reconcileValidationContexts() {
            List<ValidationContext> validationContexts = this.getValidationContexts();
            if (validationContexts.stream().noneMatch(HeaderValidationContext.class::isInstance)) {
                this.getHeaderValidationContext();
            }
            if (validationContexts.stream().noneMatch(MessageValidationContext.class::isInstance)) {
                this.injectMessageValidationContext();
            }
        }

        private void injectMessageValidationContext() {
            Optional<String> resource;
            DefaultMessageValidationContext validationContext = null;
            Optional<String> payload = this.getMessagePayload();
            if (payload.isPresent() && StringUtils.hasText(payload.get())) {
                validationContext = MessagePayloadUtils.isXml((String)payload.get()) ? new XmlMessageValidationContext() : (MessagePayloadUtils.isJson((String)payload.get()) ? new JsonMessageValidationContext() : new DefaultMessageValidationContext());
            }
            if (validationContext == null && this.messageBuilderSupport != null) {
                MessageType type = this.getMessageType((ReceiveMessageBuilderSupport)this.messageBuilderSupport);
                if (type == MessageType.XML || type == MessageType.XHTML) {
                    validationContext = new XmlMessageValidationContext();
                } else if (type == MessageType.JSON) {
                    validationContext = new JsonMessageValidationContext();
                } else if (type == MessageType.YAML) {
                    validationContext = new YamlMessageValidationContext();
                } else if (type == MessageType.PLAINTEXT) {
                    validationContext = new DefaultMessageValidationContext();
                }
            }
            if (validationContext == null && (resource = this.getMessageResource()).isPresent()) {
                String fileExt = FileUtils.getFileExtension(resource.get());
                validationContext = "xml".equalsIgnoreCase(fileExt) ? new XmlMessageValidationContext() : ("json".equalsIgnoreCase(fileExt) ? new JsonMessageValidationContext() : new DefaultMessageValidationContext());
            }
            if (validationContext != null) {
                this.validate((ValidationContext)validationContext);
            }
        }

        private MessageType getMessageType(M messageBuilderSupport) {
            WithPayloadBuilder payloadBuilder;
            MessageBuilder messageBuilder;
            if (((MessageBuilderSupport)messageBuilderSupport).getMessageBuilder().getClass().isAnnotationPresent(MessagePayload.class)) {
                return ((MessageBuilderSupport)messageBuilderSupport).getMessageBuilder().getClass().getAnnotation(MessagePayload.class).value();
            }
            if (((MessageBuilderSupport)messageBuilderSupport).getMessageBuilder() instanceof StaticMessageBuilder || (messageBuilder = ((MessageBuilderSupport)messageBuilderSupport).getMessageBuilder()) instanceof WithPayloadBuilder && (payloadBuilder = (WithPayloadBuilder)messageBuilder).getPayloadBuilder() != null) {
                MessageType messageType = MessageType.PLAINTEXT;
                try {
                    messageType = StringUtils.hasText(((MessageBuilderSupport)messageBuilderSupport).getMessageType()) && ((MessageBuilderSupport)messageBuilderSupport).isExplicitMessageType() ? MessageType.valueOf((String)((MessageBuilderSupport)messageBuilderSupport).getMessageType().toUpperCase()) : messageType;
                }
                catch (IllegalArgumentException e) {
                    return null;
                }
                return messageType;
            }
            return null;
        }

        protected Optional<String> getMessagePayload() {
            if (this.messageBuilderSupport == null) {
                return Optional.empty();
            }
            MessageBuilder messageBuilder = ((ReceiveMessageBuilderSupport)this.messageBuilderSupport).getMessageBuilder();
            if (messageBuilder instanceof StaticMessageBuilder) {
                StaticMessageBuilder staticMessageBuilder = (StaticMessageBuilder)messageBuilder;
                message = staticMessageBuilder.getMessage();
                if (message.getPayload() instanceof String) {
                    return Optional.of((String)message.getPayload(String.class));
                }
            } else {
                WithPayloadBuilder withPayloadBuilder;
                MessagePayloadBuilder messagePayloadBuilder;
                message = ((ReceiveMessageBuilderSupport)this.messageBuilderSupport).getMessageBuilder();
                if (message instanceof WithPayloadBuilder && (messagePayloadBuilder = (withPayloadBuilder = (WithPayloadBuilder)message).getPayloadBuilder()) instanceof DefaultPayloadBuilder) {
                    DefaultPayloadBuilder defaultPayloadBuilder = (DefaultPayloadBuilder)messagePayloadBuilder;
                    return Optional.ofNullable(defaultPayloadBuilder.getPayload()).map(object -> (String)TypeConverter.lookupDefault().convertIfNecessary(object, String.class));
                }
            }
            return Optional.empty();
        }

        protected Optional<String> getMessageResource() {
            WithPayloadBuilder withPayloadBuilder;
            MessagePayloadBuilder messagePayloadBuilder;
            if (this.messageBuilderSupport == null) {
                return Optional.empty();
            }
            MessageBuilder messageBuilder = ((ReceiveMessageBuilderSupport)this.messageBuilderSupport).getMessageBuilder();
            if (messageBuilder instanceof WithPayloadBuilder && (messagePayloadBuilder = (withPayloadBuilder = (WithPayloadBuilder)messageBuilder).getPayloadBuilder()) instanceof FileResourcePayloadBuilder) {
                FileResourcePayloadBuilder filePayloadBuilder = (FileResourcePayloadBuilder)messagePayloadBuilder;
                return Optional.ofNullable(filePayloadBuilder.getResourcePath());
            }
            return Optional.empty();
        }

        public List<ValidationContext> getValidationContexts() {
            return this.validationContexts.stream().map(ValidationContext.Builder::build).collect(Collectors.toList());
        }

        public List<ValidationContext.Builder<?, ?>> getValidationContextBuilders() {
            return this.validationContexts;
        }
    }

    public static class ReceiveMessageActionBuilderSupport
    extends ReceiveMessageBuilderSupport<ReceiveMessageAction, Builder, ReceiveMessageActionBuilderSupport> {
        public ReceiveMessageActionBuilderSupport(Builder delegate) {
            super(delegate);
        }
    }

    public static class Builder
    extends ReceiveMessageActionBuilder<ReceiveMessageAction, ReceiveMessageActionBuilderSupport, Builder> {
        public static Builder receive() {
            return new Builder();
        }

        public static Builder receive(Endpoint messageEndpoint) {
            Builder builder = new Builder();
            builder.endpoint(messageEndpoint);
            return builder;
        }

        public static Builder receive(String messageEndpointUri) {
            Builder builder = new Builder();
            builder.endpoint(messageEndpointUri);
            return builder;
        }

        @Override
        public ReceiveMessageActionBuilderSupport getMessageBuilderSupport() {
            if (this.messageBuilderSupport == null) {
                this.messageBuilderSupport = new ReceiveMessageActionBuilderSupport((Builder)this.self);
            }
            return (ReceiveMessageActionBuilderSupport)super.getMessageBuilderSupport();
        }

        @Override
        public ReceiveMessageAction doBuild() {
            return new ReceiveMessageAction(this);
        }
    }
}

