/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.container;

import org.citrusframework.AbstractSuiteContainerBuilder;
import org.citrusframework.AbstractTestContainerBuilder;
import org.citrusframework.TestAction;
import org.citrusframework.TestActionBuilder;
import org.citrusframework.container.AbstractSuiteActionContainer;
import org.citrusframework.container.BeforeSuite;
import org.citrusframework.context.TestContext;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SequenceBeforeSuite
extends AbstractSuiteActionContainer
implements BeforeSuite {
    private static final Logger logger = LoggerFactory.getLogger(SequenceBeforeSuite.class);

    public SequenceBeforeSuite() {
        this(new Builder());
    }

    public SequenceBeforeSuite(AbstractTestContainerBuilder<?, ?> builder) {
        super("before-suite", builder);
    }

    @Override
    public void doExecute(TestContext context) {
        logger.info("Entering before suite block");
        if (logger.isDebugEnabled()) {
            logger.debug("Executing {} actions before suite", (Object)this.actions.size());
            logger.debug("");
        }
        for (TestActionBuilder actionBuilder : this.actions) {
            TestAction action = actionBuilder.build();
            try {
                action.execute(context);
            }
            catch (Exception e) {
                logger.error("Task failed {}Nested exception is: ", (Object)action.getName(), (Object)e);
                throw new CitrusRuntimeException((Throwable)e);
            }
        }
    }

    public static class Builder
    extends AbstractSuiteContainerBuilder<SequenceBeforeSuite, Builder> {
        public static Builder beforeSuite() {
            return new Builder();
        }

        @Override
        public SequenceBeforeSuite doBuild() {
            return new SequenceBeforeSuite(this);
        }
    }
}

