/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.util;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.citrusframework.CitrusSettings;
import org.citrusframework.Completable;
import org.citrusframework.context.TestContext;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TestUtils {
    public static final String HTTPS_CITRUSFRAMEWORK_ORG = "https://citrusframework.org";
    public static final String WAIT_THREAD_PREFIX = "citrus-waiting-";
    private static final Logger logger = LoggerFactory.getLogger(TestUtils.class);

    private TestUtils() {
    }

    public static void waitForCompletion(Completable container, TestContext context) {
        TestUtils.waitForCompletion(container, context, 10000L);
    }

    public static void waitForCompletion(Completable container, TestContext context, long timeout) {
        TestUtils.waitForCompletion(Executors.newSingleThreadScheduledExecutor(runnable -> TestUtils.createWaitingThread(runnable, context)), container, context, timeout);
    }

    public static void waitForCompletion(ScheduledExecutorService scheduledExecutor, Completable container, TestContext context, long timeout) {
        if (container.isDone(context)) {
            return;
        }
        ScheduledFuture<?> scheduler = null;
        try {
            CompletableFuture finished = new CompletableFuture();
            scheduler = scheduledExecutor.scheduleAtFixedRate(() -> {
                try {
                    if (container.isDone(context)) {
                        finished.complete(true);
                    } else if (logger.isDebugEnabled()) {
                        logger.debug("Wait for test container in test '%s' to finish properly ...".formatted(TestUtils.getTestName(context)));
                    }
                }
                catch (Exception e) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Failed to wait for completion of nested test actions", (Throwable)e);
                    }
                    logger.warn("Failed to wait for completion of nested test actions because of {}", (Object)e.getMessage());
                }
            }, 100L, timeout / 10L, TimeUnit.MILLISECONDS);
            finished.get(timeout, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            throw new CitrusRuntimeException("Failed to wait for test container in test '%s' to finish properly".formatted(TestUtils.getTestName(context)), (Throwable)e);
        }
        finally {
            if (scheduler != null) {
                scheduler.cancel(true);
            }
            try {
                scheduledExecutor.shutdown();
                scheduledExecutor.awaitTermination(timeout / 10L / 2L, TimeUnit.MICROSECONDS);
            }
            catch (InterruptedException e) {
                logger.warn("Failed to await orderly termination of waiting tasks to complete, caused by {}", (Object)e.getMessage());
            }
            if (!scheduledExecutor.isTerminated()) {
                scheduledExecutor.shutdownNow();
            }
        }
    }

    public static String getTestName(TestContext context) {
        if (context.getVariables().containsKey(CitrusSettings.TEST_NAME_VARIABLE)) {
            return context.getVariable(CitrusSettings.TEST_NAME_VARIABLE);
        }
        return "";
    }

    public static String normalizeLineEndings(String text) {
        return text != null ? text.replace("\r\n", "\n").replace("&#13;", "") : null;
    }

    private static Thread createWaitingThread(Runnable runnable, TestContext context) {
        Thread waitThread = Executors.defaultThreadFactory().newThread(runnable);
        if (context.getVariables().containsKey(CitrusSettings.TEST_NAME_VARIABLE)) {
            waitThread.setName(WAIT_THREAD_PREFIX.concat(context.getVariable(CitrusSettings.TEST_NAME_VARIABLE)).concat("-").concat(waitThread.getName()));
        } else {
            waitThread.setName(WAIT_THREAD_PREFIX.concat(waitThread.getName()));
        }
        return waitThread;
    }

    public static boolean isNetworkReachable() {
        try {
            URL url = new URL(HTTPS_CITRUSFRAMEWORK_ORG);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            connection.setConnectTimeout(5000);
            connection.setReadTimeout(5000);
            int responseCode = connection.getResponseCode();
            return responseCode == 200;
        }
        catch (IOException e) {
            return false;
        }
    }
}

