/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.validation;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.citrusframework.context.TestContext;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.message.Message;
import org.citrusframework.validation.json.JsonPathMessageValidationContext;
import org.citrusframework.validation.xml.XmlNamespaceAware;
import org.citrusframework.variable.DelegatingPayloadVariableExtractorBuilder;
import org.citrusframework.variable.VariableExtractor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DelegatingPayloadVariableExtractor
implements VariableExtractor {
    private Map<String, Object> pathExpressions;
    private Map<String, String> namespaces;
    private static final Logger logger = LoggerFactory.getLogger(DelegatingPayloadVariableExtractor.class);

    public DelegatingPayloadVariableExtractor() {
        this(new Builder());
    }

    public DelegatingPayloadVariableExtractor(Builder builder) {
        this.pathExpressions = builder.expressions;
        this.namespaces = builder.namespaces;
    }

    public void extractVariables(Message message, TestContext context) {
        if (this.pathExpressions.isEmpty()) {
            return;
        }
        logger.debug("Reading path elements.");
        LinkedHashMap<String, Object> jsonPathExpressions = new LinkedHashMap<String, Object>();
        LinkedHashMap<String, Object> xpathExpressions = new LinkedHashMap<String, Object>();
        for (Map.Entry<String, Object> pathExpression : this.pathExpressions.entrySet()) {
            String path = context.replaceDynamicContentInString(pathExpression.getKey());
            Object variable = pathExpression.getValue();
            if (JsonPathMessageValidationContext.isJsonPathExpression(path)) {
                jsonPathExpressions.put(path, variable);
                continue;
            }
            xpathExpressions.put(path, variable);
        }
        if (!jsonPathExpressions.isEmpty()) {
            VariableExtractor.Builder<?, ?> jsonPathExtractor = this.lookupVariableExtractor("jsonPath", context);
            ((VariableExtractor.Builder)jsonPathExtractor.expressions(jsonPathExpressions)).build().extractVariables(message, context);
        }
        if (!xpathExpressions.isEmpty()) {
            VariableExtractor.Builder<?, ?> xpathExtractor = this.lookupVariableExtractor("xpath", context);
            if (!this.namespaces.isEmpty() && xpathExtractor instanceof XmlNamespaceAware) {
                ((XmlNamespaceAware)xpathExtractor).setNamespaces(this.namespaces);
            }
            ((VariableExtractor.Builder)xpathExtractor.expressions(xpathExpressions)).build().extractVariables(message, context);
        }
    }

    private VariableExtractor.Builder<?, ?> lookupVariableExtractor(String type, TestContext context) {
        return VariableExtractor.lookup((String)type).orElseGet(() -> {
            if (context.getReferenceResolver().isResolvable(type, VariableExtractor.Builder.class)) {
                return (VariableExtractor.Builder)context.getReferenceResolver().resolve(type, VariableExtractor.Builder.class);
            }
            if (context.getReferenceResolver().isResolvable(type + "VariableExtractorBuilder", VariableExtractor.Builder.class)) {
                return (VariableExtractor.Builder)context.getReferenceResolver().resolve(type + "VariableExtractorBuilder", VariableExtractor.Builder.class);
            }
            throw new CitrusRuntimeException(String.format("Missing proper variable extractor implementation of type '%s' - consider adding proper validation module to the project", type));
        });
    }

    public void setPathExpressions(Map<String, Object> pathExpressions) {
        this.pathExpressions = pathExpressions;
    }

    public Map<String, Object> getPathExpressions() {
        return this.pathExpressions;
    }

    public Map<String, String> getNamespaces() {
        return this.namespaces;
    }

    public void setNamespaces(Map<String, String> namespaces) {
        this.namespaces = namespaces;
    }

    public static final class Builder
    implements DelegatingPayloadVariableExtractorBuilder<DelegatingPayloadVariableExtractor, Builder> {
        private final Map<String, Object> expressions = new LinkedHashMap<String, Object>();
        private final Map<String, String> namespaces = new HashMap<String, String>();

        public static Builder fromBody() {
            return new Builder();
        }

        public Builder namespaces(Map<String, String> namespaces) {
            this.namespaces.putAll(namespaces);
            return this;
        }

        public Builder namespace(String prefix, String namespace) {
            this.namespaces.put(prefix, namespace);
            return this;
        }

        public Builder expressions(Map<String, Object> expressions) {
            this.expressions.putAll(expressions);
            return this;
        }

        public Builder expression(String path, Object variableName) {
            this.expressions.put(path, variableName);
            return this;
        }

        public DelegatingPayloadVariableExtractor build() {
            return new DelegatingPayloadVariableExtractor(this);
        }
    }
}

