/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.validation.json;

import java.util.HashMap;
import java.util.Map;
import org.citrusframework.message.DelegatingPathExpressionProcessor;
import org.citrusframework.message.MessageProcessor;
import org.citrusframework.util.StringUtils;
import org.citrusframework.validation.DelegatingPayloadVariableExtractor;
import org.citrusframework.validation.context.DefaultValidationContext;
import org.citrusframework.validation.json.JsonPathMessageValidationContextBuilder;
import org.citrusframework.variable.VariableExtractor;

public class JsonPathMessageValidationContext
extends DefaultValidationContext {
    private final Map<String, Object> jsonPathExpressions;

    public JsonPathMessageValidationContext(Builder builder) {
        this.jsonPathExpressions = builder.expressions;
    }

    public JsonPathMessageValidationContext() {
        this(new Builder());
    }

    public boolean requiresValidator() {
        return true;
    }

    public Map<String, Object> getJsonPathExpressions() {
        return this.jsonPathExpressions;
    }

    public static boolean isJsonPathExpression(String pathExpression) {
        return StringUtils.hasText(pathExpression) && pathExpression.startsWith("$");
    }

    public static final class Builder
    implements JsonPathMessageValidationContextBuilder<JsonPathMessageValidationContext, Builder> {
        private final Map<String, Object> expressions = new HashMap<String, Object>();

        public static Builder jsonPath() {
            return new Builder();
        }

        public Builder expressions(Map<String, Object> expressions) {
            this.expressions.putAll(expressions);
            return this;
        }

        public Builder expression(String expression, Object value) {
            this.expressions.put(expression, value);
            return this;
        }

        public MessageProcessor asProcessor() {
            return ((DelegatingPathExpressionProcessor.Builder)new DelegatingPathExpressionProcessor.Builder().expressions((Map)this.expressions)).build();
        }

        public VariableExtractor asExtractor() {
            return ((DelegatingPayloadVariableExtractor.Builder)new DelegatingPayloadVariableExtractor.Builder().expressions((Map)this.expressions)).build();
        }

        public JsonPathMessageValidationContext build() {
            return new JsonPathMessageValidationContext(this);
        }
    }
}

