/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.cucumber;

import io.cucumber.java.After;
import io.cucumber.java.Before;
import org.citrusframework.Citrus;
import org.citrusframework.TestCase;
import org.citrusframework.TestCaseRunner;
import org.citrusframework.TestResult;
import org.citrusframework.annotations.CitrusFramework;
import org.citrusframework.annotations.CitrusResource;
import org.citrusframework.context.TestContext;
import org.citrusframework.cucumber.backend.Scenario;
import org.citrusframework.exceptions.CitrusRuntimeException;

public class CitrusLifecycleHooks {
    @CitrusFramework
    protected Citrus citrus;
    @CitrusResource
    protected TestCaseRunner runner;
    @CitrusResource
    private TestContext context;

    @Before
    public void before(Scenario scenario) {
        if (this.runner != null) {
            this.runner.name(scenario.getName());
            this.runner.description(scenario.getId());
            this.runner.start();
        }
    }

    @After
    public void after(Scenario scenario) {
        if (this.runner != null) {
            TestCase testCase;
            TestResult testResult;
            if (this.context != null && scenario.isFailed() && ((testResult = (testCase = this.runner.getTestCase()).getTestResult()) == null || !testResult.isFailed())) {
                this.runner.getTestCase().setTestResult(TestResult.failed((String)testCase.getName(), (String)testCase.getTestClass().getName(), (Throwable)new CitrusRuntimeException(String.format("Scenario '%s' (%s) status %s", scenario.getName(), scenario.getId(), scenario.getStatus().name()))));
            }
            this.runner.stop();
        }
    }
}

