/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.cucumber.backend.spring;

import io.cucumber.core.backend.Container;
import io.cucumber.core.backend.Glue;
import io.cucumber.core.backend.Lookup;
import io.cucumber.core.backend.StepDefinition;
import io.cucumber.core.resource.ClasspathSupport;
import java.net.URI;
import java.util.List;
import java.util.Map;
import org.citrusframework.Citrus;
import org.citrusframework.CitrusInstanceManager;
import org.citrusframework.CitrusInstanceProcessor;
import org.citrusframework.CitrusSpringContext;
import org.citrusframework.cucumber.backend.CitrusBackend;
import org.citrusframework.cucumber.container.StepTemplate;
import org.citrusframework.cucumber.step.xml.XmlStepDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class CitrusSpringBackend
extends CitrusBackend {
    private static Logger log = LoggerFactory.getLogger(CitrusSpringBackend.class);

    public CitrusSpringBackend(Lookup lookup, Container container) {
        super(lookup, container);
    }

    @Override
    public void loadGlue(Glue glue, List<URI> gluePaths) {
        if (CitrusInstanceManager.hasInstance()) {
            new XmlStepInstanceProcessor(glue, gluePaths, this.lookup).process(CitrusInstanceManager.getOrDefault());
        } else {
            CitrusInstanceManager.addInstanceProcessor((CitrusInstanceProcessor)new XmlStepInstanceProcessor(glue, gluePaths, this.lookup));
        }
        super.loadGlue(glue, gluePaths);
    }

    private static class XmlStepInstanceProcessor
    implements CitrusInstanceProcessor {
        private final Glue glue;
        private final List<URI> gluePaths;
        private final Lookup lookup;

        XmlStepInstanceProcessor(Glue glue, List<URI> gluePaths, Lookup lookup) {
            this.glue = glue;
            this.gluePaths = gluePaths;
            this.lookup = lookup;
        }

        public void process(Citrus instance) {
            for (URI gluePath : this.gluePaths) {
                String xmlStepConfigLocation = "classpath*:" + ClasspathSupport.resourceNameOfPackageName((String)ClasspathSupport.packageName((URI)gluePath)) + "/**/*Steps.xml";
                log.info(String.format("Loading XML step definitions %s", xmlStepConfigLocation));
                ClassPathXmlApplicationContext ctx = instance.getCitrusContext() instanceof CitrusSpringContext ? new ClassPathXmlApplicationContext(new String[]{xmlStepConfigLocation}, true, ((CitrusSpringContext)instance.getCitrusContext()).getApplicationContext()) : new ClassPathXmlApplicationContext(new String[]{xmlStepConfigLocation}, true);
                Map xmlSteps = ctx.getBeansOfType(StepTemplate.class);
                for (StepTemplate stepTemplate : xmlSteps.values()) {
                    if (log.isDebugEnabled()) {
                        log.debug(String.format("Found XML step definition: %s %s", stepTemplate.getName(), stepTemplate.getPattern().pattern()));
                    }
                    this.glue.addStepDefinition((StepDefinition)new XmlStepDefinition(stepTemplate, this.lookup));
                }
            }
        }
    }
}

