/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.cucumber.config.xml;

import java.util.List;
import java.util.regex.Pattern;
import org.citrusframework.TestAction;
import org.citrusframework.config.xml.AbstractTestActionFactoryBean;
import org.citrusframework.config.xml.ActionContainerParser;
import org.citrusframework.config.xml.DescriptionElementParser;
import org.citrusframework.cucumber.container.StepTemplate;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public class StepTemplateParser
implements BeanDefinitionParser {
    public BeanDefinition parse(Element element, ParserContext parserContext) {
        String globalContext;
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition(StepTemplateFactoryBean.class);
        DescriptionElementParser.doParse((Element)element, (BeanDefinitionBuilder)builder);
        if (element.hasAttribute("given")) {
            builder.addPropertyValue("name", (Object)(element.getLocalName() + "(given)"));
            builder.addPropertyValue("pattern", (Object)Pattern.compile(element.getAttribute("given")));
        } else if (element.hasAttribute("when")) {
            builder.addPropertyValue("name", (Object)(element.getLocalName() + "(when)"));
            builder.addPropertyValue("pattern", (Object)Pattern.compile(element.getAttribute("when")));
        } else if (element.hasAttribute("then")) {
            builder.addPropertyValue("name", (Object)(element.getLocalName() + "(then)"));
            builder.addPropertyValue("pattern", (Object)Pattern.compile(element.getAttribute("then")));
        }
        if (element.hasAttribute("parameter-names")) {
            builder.addPropertyValue("parameterNames", (Object)StringUtils.commaDelimitedListToStringArray((String)element.getAttribute("parameter-names")));
        }
        if (StringUtils.hasText((String)(globalContext = element.getAttribute("global-context")))) {
            builder.addPropertyValue("globalContext", (Object)globalContext);
        }
        ActionContainerParser.doParse((Element)element, (ParserContext)parserContext, (BeanDefinitionBuilder)builder);
        String beanName = parserContext.getReaderContext().generateBeanName((BeanDefinition)builder.getBeanDefinition());
        parserContext.getRegistry().registerBeanDefinition(beanName, (BeanDefinition)builder.getBeanDefinition());
        return parserContext.getRegistry().getBeanDefinition(beanName);
    }

    public static class StepTemplateFactoryBean
    extends AbstractTestActionFactoryBean<StepTemplate, StepTemplate.Builder> {
        private final StepTemplate.Builder builder = new StepTemplate.Builder();

        public void setPattern(Pattern pattern) {
            this.builder.pattern(pattern);
        }

        public void setParameterNames(List<String> parameterNames) {
            this.builder.parameterNames(parameterNames);
        }

        public void setActions(List<TestAction> actions) {
            this.builder.actions(actions);
        }

        public StepTemplate getObject() throws Exception {
            return this.builder.build();
        }

        public Class<?> getObjectType() {
            return StepTemplate.class;
        }

        public StepTemplate.Builder getBuilder() {
            return this.builder;
        }
    }
}

