/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.cucumber.backend.spring;

import io.cucumber.core.backend.CucumberBackendException;
import io.cucumber.core.backend.ObjectFactory;
import io.cucumber.spring.SpringFactory;
import org.citrusframework.Citrus;
import org.citrusframework.CitrusContext;
import org.citrusframework.CitrusContextProvider;
import org.citrusframework.CitrusInstanceManager;
import org.citrusframework.CitrusSpringContext;
import org.citrusframework.CitrusSpringContextProvider;
import org.citrusframework.TestCaseRunner;
import org.citrusframework.TestCaseRunnerFactory;
import org.citrusframework.annotations.CitrusAnnotations;
import org.citrusframework.context.TestContext;
import org.citrusframework.context.TestContextFactoryBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;

public class CitrusSpringObjectFactory
implements ObjectFactory {
    private static final Logger logger = LoggerFactory.getLogger(CitrusSpringObjectFactory.class);
    private TestCaseRunner runner;
    private TestContext context;
    private static CitrusSpringObjectFactory selfReference;
    private final SpringFactory delegate = new SpringFactory();

    public CitrusSpringObjectFactory() {
        selfReference = this;
    }

    public void start() {
        this.delegate.start();
        this.context = this.getInstance(TestContext.class);
        this.runner = TestCaseRunnerFactory.createRunner((TestContext)this.context);
    }

    public void stop() {
        this.delegate.stop();
    }

    public <T> T getInstance(Class<T> type) {
        if (this.context == null) {
            try {
                TestContextFactoryBean contextFactoryBean = (TestContextFactoryBean)this.delegate.getInstance(TestContextFactoryBean.class);
                this.context = contextFactoryBean.getObject();
                this.initializeCitrus(this.context, contextFactoryBean.getApplicationContext());
            }
            catch (CucumberBackendException e) {
                logger.warn("Failed to get proper TestContext from Cucumber Spring application context: " + e.getMessage());
                this.context = CitrusInstanceManager.getOrDefault().getCitrusContext().createTestContext();
            }
        }
        if (TestContext.class.isAssignableFrom(type)) {
            return (T)this.context;
        }
        if (CitrusSpringObjectFactory.class.isAssignableFrom(type)) {
            return (T)this;
        }
        Object instance = this.delegate.getInstance(type);
        CitrusAnnotations.injectAll((Object)instance, (Citrus)CitrusInstanceManager.getOrDefault(), (TestContext)this.context);
        CitrusAnnotations.injectTestRunner((Object)instance, (TestCaseRunner)this.runner);
        return (T)instance;
    }

    private void initializeCitrus(TestContext context, ApplicationContext applicationContext) {
        if (CitrusInstanceManager.hasInstance()) {
            CitrusContext citrusContext = CitrusInstanceManager.getOrDefault().getCitrusContext();
            if (citrusContext instanceof CitrusSpringContext && !((CitrusSpringContext)citrusContext).getApplicationContext().equals(applicationContext)) {
                logger.warn("Citrus instance has already been initialized - creating new instance and shutting down current instance");
                citrusContext.close();
            } else {
                return;
            }
        }
        Citrus.newInstance((CitrusContextProvider)new CitrusSpringContextProvider(applicationContext));
    }

    public boolean addClass(Class<?> glueClass) {
        return this.delegate.addClass(glueClass);
    }

    public static CitrusSpringObjectFactory instance() throws IllegalAccessException {
        if (selfReference == null) {
            throw new IllegalAccessException("Illegal access to self reference - not available yet");
        }
        return selfReference;
    }
}

