/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.cucumber.backend;

import io.cucumber.core.backend.Backend;
import io.cucumber.core.backend.Container;
import io.cucumber.core.backend.Glue;
import io.cucumber.core.backend.HookDefinition;
import io.cucumber.core.backend.Lookup;
import io.cucumber.core.backend.Snippet;
import io.cucumber.core.exception.CucumberException;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.List;
import org.citrusframework.CitrusInstanceManager;
import org.citrusframework.cucumber.CitrusLifecycleHooks;
import org.citrusframework.cucumber.backend.CitrusHookDefinition;
import org.citrusframework.cucumber.backend.NoopSnippet;
import org.citrusframework.cucumber.backend.Scenario;

public class CitrusBackend
implements Backend {
    protected final Lookup lookup;
    protected final Container container;

    public CitrusBackend(Lookup lookup, Container container) {
        this.lookup = lookup;
        this.container = container;
        CitrusInstanceManager.addInstanceProcessor(instance -> instance.beforeSuite("cucumber-suite", new String[0]));
    }

    public void loadGlue(Glue glue, List<URI> gluePaths) {
        try {
            if (this.container.addClass(CitrusLifecycleHooks.class)) {
                Method beforeMethod = CitrusLifecycleHooks.class.getMethod("before", Scenario.class);
                glue.addBeforeHook((HookDefinition)new CitrusHookDefinition(beforeMethod, "", 10000, this.lookup));
                Method afterMethod = CitrusLifecycleHooks.class.getMethod("after", Scenario.class);
                glue.addAfterHook((HookDefinition)new CitrusHookDefinition(afterMethod, "", 10000, this.lookup));
            }
        }
        catch (NoSuchMethodException e) {
            throw new CucumberException("Unable to add Citrus lifecycle hooks");
        }
    }

    public void buildWorld() {
    }

    public void disposeWorld() {
    }

    public Snippet getSnippet() {
        return new NoopSnippet();
    }
}

