/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.cucumber;

import io.cucumber.core.backend.ObjectFactory;
import io.cucumber.core.eventbus.RandomUuidGenerator;
import io.cucumber.core.eventbus.UuidGenerator;
import io.cucumber.core.options.CommandlineOptionsParser;
import io.cucumber.core.options.CucumberOptionsAnnotationParser;
import io.cucumber.core.options.CucumberProperties;
import io.cucumber.core.options.CucumberPropertiesParser;
import io.cucumber.core.options.RuntimeOptions;
import io.cucumber.core.runtime.Runtime;
import io.cucumber.core.snippets.SnippetType;
import io.cucumber.plugin.Plugin;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.citrusframework.TestSource;
import org.citrusframework.common.TestSourceHelper;
import org.citrusframework.cucumber.CitrusReporter;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.main.AbstractTestEngine;
import org.citrusframework.main.TestRunConfiguration;
import org.citrusframework.spi.ClasspathResourceResolver;
import org.citrusframework.spi.Resource;
import org.citrusframework.spi.Resources;
import org.citrusframework.util.FileUtils;
import org.citrusframework.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CucumberTestEngine
extends AbstractTestEngine {
    private static final Logger logger = LoggerFactory.getLogger(CucumberTestEngine.class);

    public CucumberTestEngine(TestRunConfiguration configuration) {
        super(configuration);
    }

    public void run() {
        RuntimeOptions annotationOptions;
        RuntimeOptions propertiesFileOptions = new CucumberPropertiesParser().parse(CucumberProperties.fromPropertiesFile()).build();
        Optional<TestSource> javaClass = this.getConfiguration().getTestSources().stream().filter(source -> "java".equals(source.getType())).findFirst();
        if (javaClass.isEmpty()) {
            annotationOptions = propertiesFileOptions;
        } else {
            try {
                annotationOptions = new CucumberOptionsAnnotationParser().withOptionsProvider(GenericCucumberOptions::new).parse(Class.forName(javaClass.get().getName())).setUuidGeneratorClass(RandomUuidGenerator.class).addDefaultGlueIfAbsent().build(propertiesFileOptions);
            }
            catch (ClassNotFoundException e) {
                throw new CitrusRuntimeException("Unable to find test class in classpath: " + javaClass.get().getName());
            }
        }
        ArrayList<String> features = new ArrayList<String>();
        this.addToFeatures(features, this.getConfiguration().getTestSources());
        if (!features.isEmpty()) {
            System.setProperty("cucumber.features", String.join((CharSequence)",", features));
        }
        RuntimeOptions environmentOptions = new CucumberPropertiesParser().parse(CucumberProperties.fromEnvironment()).build(annotationOptions);
        RuntimeOptions systemOptions = new CucumberPropertiesParser().parse(CucumberProperties.fromSystemProperties()).build(environmentOptions);
        ArrayList<Object> args = new ArrayList<Object>();
        List packagesToRun = this.getConfiguration().getPackages();
        if (packagesToRun == null || packagesToRun.isEmpty()) {
            logger.info("Running all tests in project");
        } else if (StringUtils.hasText((String)((String)packagesToRun.get(0)))) {
            logger.info(String.format("Running tests in package %s", packagesToRun.get(0)));
            args.add("classpath:" + ((String)packagesToRun.get(0)).replaceAll("\\.", "/"));
            args.add("--glue");
            args.add((String)packagesToRun.get(0));
        }
        CommandlineOptionsParser commandlineOptionsParser = new CommandlineOptionsParser((OutputStream)System.out);
        RuntimeOptions runtimeOptions = commandlineOptionsParser.parse(args.toArray(new String[0])).addDefaultGlueIfAbsent().addDefaultFeaturePathIfAbsent().addDefaultSummaryPrinterIfNotDisabled().build(systemOptions);
        Runtime runtime = Runtime.builder().withRuntimeOptions(runtimeOptions).withAdditionalPlugins(new Plugin[]{new CitrusReporter()}).build();
        runtime.run();
    }

    private void addToFeatures(List<String> features, List<TestSource> testSources) {
        List<TestSource> directories = testSources.stream().filter(source -> "directory".equals(source.getType())).toList();
        for (TestSource directory : directories) {
            Resource sourceDir = Resources.create((String)directory.getFilePath());
            if (!sourceDir.exists()) continue;
            if (sourceDir instanceof Resources.ClasspathResource) {
                try {
                    this.addToFeatures(features, new ClasspathResourceResolver().getResources(sourceDir.getLocation()).stream().map(Path::toString).map(TestSourceHelper::create).collect(Collectors.toList()));
                    continue;
                }
                catch (IOException e) {
                    throw new CitrusRuntimeException("Failed to resolve files from resource directory '%s'".formatted(sourceDir.getLocation()), (Throwable)e);
                }
            }
            this.addToFeatures(features, Optional.ofNullable(sourceDir.getFile().list()).stream().flatMap(Arrays::stream).map(file -> directory.getFilePath() + File.separator + file).map(TestSourceHelper::create).collect(Collectors.toList()));
        }
        features.addAll(testSources.stream().filter(source -> "cucumber".equals(source.getType()) || Optional.ofNullable(source.getFilePath()).filter(it -> it.endsWith(".feature")).isPresent() || "feature".equals(FileUtils.getFileExtension((String)source.getName()))).map(TestSource::getName).toList());
    }

    private static class GenericCucumberOptions
    implements CucumberOptionsAnnotationParser.CucumberOptions {
        private final Annotation options;

        public GenericCucumberOptions(Class<?> clazz) {
            this.options = Arrays.stream(clazz.getAnnotations()).filter(annotation -> annotation.annotationType().getSimpleName().equals("CucumberOptions")).findFirst().orElseThrow(() -> new CitrusRuntimeException("Missing CucumberOptions annotation on test class: " + clazz.getName()));
        }

        <T> T getOptionValue(String optionName) {
            try {
                Method method = this.options.annotationType().getDeclaredMethod(optionName, new Class[0]);
                return (T)method.invoke((Object)this.options, new Object[0]);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                throw new CitrusRuntimeException(String.format("Failed to retrieve Cucumber option %s on annotation type %s", optionName, this.options.annotationType()));
            }
        }

        public boolean dryRun() {
            return (Boolean)this.getOptionValue("dryRun");
        }

        public String[] features() {
            return (String[])this.getOptionValue("features");
        }

        public String[] glue() {
            return (String[])this.getOptionValue("glue");
        }

        public String[] extraGlue() {
            return (String[])this.getOptionValue("extraGlue");
        }

        public String tags() {
            return (String)this.getOptionValue("tags");
        }

        public String[] plugin() {
            return (String[])this.getOptionValue("plugin");
        }

        public boolean publish() {
            return (Boolean)this.getOptionValue("publish");
        }

        public boolean monochrome() {
            return (Boolean)this.getOptionValue("monochrome");
        }

        public String[] name() {
            return (String[])this.getOptionValue("name");
        }

        public SnippetType snippets() {
            return SnippetType.UNDERSCORE;
        }

        public Class<? extends UuidGenerator> uuidGenerator() {
            return (Class)this.getOptionValue("uuidGenerator");
        }

        public Class<? extends ObjectFactory> objectFactory() {
            Class factoryType = (Class)this.getOptionValue("objectFactory");
            if (factoryType.getSimpleName().equals("NoObjectFactory")) {
                return null;
            }
            return factoryType;
        }
    }
}

