/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.docs;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Properties;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.citrusframework.docs.AbstractTestDocsGenerator;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public final class SvgTestDocsGenerator
extends AbstractTestDocsGenerator {
    private static final Logger logger = LoggerFactory.getLogger(SvgTestDocsGenerator.class);

    public SvgTestDocsGenerator() {
        super("", "");
    }

    @Override
    public void generateDoc() {
        FileOutputStream fos = null;
        BufferedOutputStream buffered = null;
        Transformer t = this.getTransformer("generate-svg-doc.xslt", "text/xml", "xml");
        t.setOutputProperty("indent", "yes");
        t.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
        try {
            List<File> testFiles = this.getTestFiles();
            for (File testFile : testFiles) {
                logger.info("Working on test " + testFile.getName());
                fos = this.getFileOutputStream(testFile.getName().substring(0, testFile.getName().lastIndexOf(46)) + ".svg");
                buffered = new BufferedOutputStream(fos);
                DOMSource xml = new DOMSource(this.getDocumentBuilder().parse(testFile));
                StreamResult res = new StreamResult(buffered);
                t.transform(xml, res);
                logger.info("Finished test " + testFile.getName());
                buffered.flush();
                fos.close();
            }
        }
        catch (TransformerException e) {
            throw new CitrusRuntimeException((Throwable)e);
        }
        catch (SAXException e) {
            throw new CitrusRuntimeException((Throwable)e);
        }
        catch (IOException e) {
            throw new CitrusRuntimeException((Throwable)e);
        }
        finally {
            if (buffered != null) {
                try {
                    buffered.flush();
                }
                catch (IOException e) {
                    logger.error("Failed to close output stream", (Throwable)e);
                }
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {
                    logger.error("Failed to close file", (Throwable)e);
                }
            }
        }
    }

    public static SvgTestDocsGenerator build() {
        return new SvgTestDocsGenerator();
    }

    public SvgTestDocsGenerator useSrcDirectory(String testDir) {
        this.setSrcDirectory(testDir);
        return this;
    }

    @Override
    public void doBody(OutputStream buffered) throws TransformerException, IOException, SAXException {
    }

    @Override
    public void doHeader(OutputStream buffered) throws TransformerException, IOException, SAXException {
    }

    @Override
    protected Properties getTestDocProperties() {
        return null;
    }
}

