/*
 * Copyright the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.citrusframework.dsl.endpoint.docker;

import org.citrusframework.docker.client.DockerClientBuilder;
import org.citrusframework.docker.endpoint.builder.DockerEndpoints;

/**
 * @author Christoph Deppisch
 */
public class DockerEndpointCatalog {

    /**
     * Private constructor setting the client and server builder implementation.
     */
    private DockerEndpointCatalog() {
        // prevent direct instantiation
    }

    public static DockerEndpointCatalog docker() {
        return new DockerEndpointCatalog();
    }

    /**
     * Gets the client builder.
     * @return
     */
    public DockerClientBuilder client() {
        return DockerEndpoints.docker().client();
    }

    /**
     * Gets the client builder.
     * @return
     */
    public DockerClientBuilder server() {
        return DockerEndpoints.docker().server();
    }
}
