/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.groovy;

import java.io.File;
import java.io.IOException;
import org.citrusframework.common.DefaultTestLoader;
import org.citrusframework.common.TestSourceAware;
import org.citrusframework.context.TestContext;
import org.citrusframework.groovy.dsl.GroovyShellUtils;
import org.citrusframework.groovy.dsl.test.TestCaseScript;
import org.citrusframework.util.FileUtils;
import org.codehaus.groovy.control.customizers.ImportCustomizer;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.util.StringUtils;

public class GroovyTestLoader
extends DefaultTestLoader
implements TestSourceAware {
    private String source;

    protected void doLoad() {
        try {
            Resource scriptSource = FileUtils.getFileResource((String)this.getSource(), (TestContext)this.context);
            ImportCustomizer ic = new ImportCustomizer();
            String basePath = scriptSource.getFile().getParent();
            if (scriptSource instanceof ClassPathResource) {
                basePath = FileUtils.getBasePath((String)((ClassPathResource)scriptSource).getPath());
            }
            String source = FileUtils.readToString((Resource)scriptSource);
            GroovyShellUtils.autoAddImports(source, ic);
            this.testCase = this.runner.getTestCase();
            this.configurer.forEach(it -> it.accept(this.testCase));
            this.runner.start();
            GroovyShellUtils.run(ic, new TestCaseScript(this.citrus, this.runner, this.context, basePath), source, this.citrus, this.context);
            this.handler.forEach(it -> it.accept(this.testCase));
        }
        catch (IOException e) {
            throw this.citrusContext.getTestContextFactory().getObject().handleError(this.testName, this.packageName, "Failed to load Groovy test source '" + this.testName + "'", (Exception)e);
        }
    }

    public String getSource() {
        if (StringUtils.hasText((String)this.source)) {
            return this.source;
        }
        String path = this.packageName.replace('.', File.separatorChar);
        Object fileName = this.testName.endsWith(".groovy") ? this.testName : this.testName + ".groovy";
        return "classpath:" + path + File.separator + (String)fileName;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public GroovyTestLoader source(String source) {
        this.setSource(source);
        return this;
    }
}

