/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.groovy.dsl.actions;

import groovy.lang.Closure;
import groovy.lang.DelegatesTo;
import groovy.lang.GroovyObjectSupport;
import java.util.Optional;
import org.citrusframework.TestAction;
import org.citrusframework.TestActionBuilder;
import org.citrusframework.container.Template;
import org.citrusframework.groovy.dsl.actions.ActionsBuilder;

public class TemplateConfiguration
implements ActionsBuilder {
    private final Template.Builder target;

    public TemplateConfiguration(Template.Builder builder) {
        this.target = builder;
    }

    @Override
    public void actions(@DelegatesTo(value=TemplateConfiguration.class) Closure<?> callable) {
        callable.setResolveStrategy(1);
        callable.setDelegate((Object)this);
        callable.call();
    }

    public void name(String templateName) {
        this.target.templateName(templateName);
    }

    public void description(String description) {
        this.target.description(description);
    }

    public void globalContext(boolean global) {
        this.target.globalContext(global);
    }

    public void $actions(@DelegatesTo(value=TemplateConfiguration.class) Closure<?> callable) {
        this.actions(callable);
    }

    public void parameters(@DelegatesTo(value=ParameterConfiguration.class) Closure<?> callable) {
        callable.setResolveStrategy(1);
        callable.setDelegate((Object)new ParameterConfiguration(this.target));
        callable.call();
    }

    @Override
    public <T extends TestAction> T $(TestActionBuilder<T> builder) {
        TestAction action = builder.build();
        this.target.actions(new TestAction[]{action});
        return (T)action;
    }

    private static class ParameterConfiguration
    extends GroovyObjectSupport {
        private final Template.Builder target;

        public ParameterConfiguration(Template.Builder builder) {
            this.target = builder;
        }

        public void propertyMissing(String name, Object value) {
            this.target.parameter(name, Optional.ofNullable(value).map(Object::toString).orElse("").trim());
        }
    }
}

