/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.groovy.dsl.configuration.endpoints;

import java.util.function.Supplier;
import org.citrusframework.endpoint.AbstractEndpointBuilder;
import org.citrusframework.endpoint.Endpoint;
import org.citrusframework.endpoint.EndpointBuilder;
import org.citrusframework.exceptions.CitrusRuntimeException;

public class EndpointBuilderWrapper
implements Supplier<Endpoint> {
    private EndpointBuilder<?> builder;
    private final String type;
    private final String endpointName;

    public EndpointBuilderWrapper(String type, String endpointName) {
        this.type = type;
        this.endpointName = endpointName;
    }

    public EndpointBuilder<?> client() {
        return this.resolve(this.type + ".client");
    }

    public EndpointBuilder<?> server() {
        return this.resolve(this.type + ".server");
    }

    public EndpointBuilder<?> synchronous() {
        return this.resolve(this.type + ".sync");
    }

    public EndpointBuilder<?> asynchronous() {
        return this.resolve(this.type + ".async");
    }

    private EndpointBuilder<?> resolve(String name) {
        this.builder = (EndpointBuilder)EndpointBuilder.lookup((String)name).orElseThrow(() -> new CitrusRuntimeException(String.format("Failed to resolve endpoint for type %s", name)));
        if (this.builder instanceof AbstractEndpointBuilder) {
            ((AbstractEndpointBuilder)this.builder).name(this.endpointName);
        }
        return this.builder;
    }

    @Override
    public Endpoint get() {
        if (this.builder != null) {
            return this.builder.build();
        }
        return null;
    }
}

