/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.message.builder.script;

import groovy.lang.GroovyClassLoader;
import groovy.lang.GroovyObject;
import org.citrusframework.context.TestContext;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.message.ScriptPayloadBuilder;
import org.citrusframework.message.builder.script.GroovyFileResourcePayloadBuilder;
import org.citrusframework.spi.Resource;
import org.citrusframework.spi.Resources;
import org.citrusframework.validation.script.TemplateBasedScriptBuilder;
import org.codehaus.groovy.control.CompilationFailedException;

public class GroovyScriptPayloadBuilder
implements ScriptPayloadBuilder {
    private final Resource scriptTemplateResource = Resources.fromClasspath((String)"org/citrusframework/script/markup-builder-template.groovy");
    private String script;
    private GroovyFileResourcePayloadBuilder delegate;

    public GroovyScriptPayloadBuilder() {
    }

    public GroovyScriptPayloadBuilder(String script) {
        this.script = script;
    }

    public GroovyScriptPayloadBuilder(Resource file) {
        this.delegate = new GroovyFileResourcePayloadBuilder(file);
    }

    public Object buildPayload(TestContext context) {
        if (this.delegate != null) {
            return this.delegate.buildPayload(context);
        }
        return this.buildMarkupBuilderScript(context.replaceDynamicContentInString(this.script));
    }

    protected String buildMarkupBuilderScript(String scriptData) {
        try {
            ClassLoader parent = GroovyScriptPayloadBuilder.class.getClassLoader();
            GroovyClassLoader loader = new GroovyClassLoader(parent);
            Class groovyClass = loader.parseClass(TemplateBasedScriptBuilder.fromTemplateResource((Resource)this.scriptTemplateResource).withCode(scriptData).build());
            if (groovyClass == null) {
                throw new CitrusRuntimeException("Could not load groovy script!");
            }
            GroovyObject groovyObject = (GroovyObject)groovyClass.newInstance();
            return (String)groovyObject.invokeMethod("run", (Object)new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | CompilationFailedException e) {
            throw new CitrusRuntimeException(e);
        }
    }

    public void setScript(String script) {
        this.script = script;
    }

    public void setFile(String file) {
        this.delegate = new GroovyFileResourcePayloadBuilder(file);
    }

    public void setFile(String file, String charset) {
        this.delegate = new GroovyFileResourcePayloadBuilder(file, charset);
    }
}

