/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.groovy.dsl;

import groovy.lang.Binding;
import groovy.lang.GroovyShell;
import groovy.lang.Script;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.citrusframework.Citrus;
import org.citrusframework.TestActionBuilder;
import org.citrusframework.context.TestContext;
import org.citrusframework.groovy.dsl.GroovyScript;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.control.customizers.CompilationCustomizer;
import org.codehaus.groovy.control.customizers.ImportCustomizer;

public class GroovyShellUtils {
    private static final Pattern COMMENTS = Pattern.compile("^(?:\\s*//|/\\*|\\s+\\*).*$", 8);

    private GroovyShellUtils() {
    }

    public static <T> T run(ImportCustomizer ic, String scriptCode, Citrus citrus, TestContext context) {
        return GroovyShellUtils.run(ic, null, scriptCode, citrus, context);
    }

    public static <T> T run(Object delegate, String scriptCode, Citrus citrus, TestContext context) {
        return GroovyShellUtils.run(new ImportCustomizer(), delegate, scriptCode, citrus, context);
    }

    public static <T> T run(ImportCustomizer ic, Object delegate, String scriptCode, Citrus citrus, TestContext context) {
        CompilerConfiguration cc = new CompilerConfiguration();
        cc.addCompilationCustomizers(new CompilationCustomizer[]{ic});
        cc.setScriptBaseClass(GroovyScript.class.getName());
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        GroovyShell sh = new GroovyShell(cl, new Binding(), cc);
        Script script = sh.parse(scriptCode);
        if (script instanceof GroovyScript) {
            if (delegate != null) {
                ((GroovyScript)script).setDelegate(delegate);
            }
            ((GroovyScript)script).setCitrusFramework(citrus);
            ((GroovyScript)script).setContext(context);
        }
        return (T)script.run();
    }

    public static String removeComments(String script) {
        Matcher matcher = COMMENTS.matcher(script);
        if (matcher.find()) {
            return matcher.replaceAll("").trim();
        }
        return script.trim();
    }

    public static void autoAddImports(String source, ImportCustomizer ic) {
        TestActionBuilder.lookup().entrySet().stream().filter(entry -> !((String)entry.getKey()).equals("send") && !((String)entry.getKey()).equals("receive")).filter(entry -> !source.contains("import static " + String.format("%s.%s", ((TestActionBuilder)entry.getValue()).getClass().getCanonicalName(), entry.getKey()))).filter(entry -> source.contains(String.format("$(%s(", entry.getKey())) || source.contains(String.format("%s()", entry.getKey()))).peek(entry -> System.out.println((String)entry.getKey())).forEach(entry -> ic.addStaticImport(((TestActionBuilder)entry.getValue()).getClass().getCanonicalName(), (String)entry.getKey()));
    }
}

