/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.groovy.dsl.configuration.endpoints;

import org.citrusframework.endpoint.EndpointBuilder;
import org.citrusframework.exceptions.CitrusRuntimeException;

public class EndpointBuilderHelper {
    private EndpointBuilderHelper() {
    }

    public static String sanitizeEndpointBuilderName(String name) {
        if (name.equals("synchronous")) {
            return "sync";
        }
        if (name.equals("asynchronous")) {
            return "async";
        }
        return name;
    }

    public static EndpointBuilder<?> find(String name) {
        try {
            EndpointBuilder builder = (EndpointBuilder)EndpointBuilder.lookup().get(name);
            if (builder == null) {
                throw new CitrusRuntimeException(String.format("Unable to find endpoint builder for resource path '%s'", name));
            }
            return (EndpointBuilder)builder.getClass().newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new CitrusRuntimeException("Unable to instantiate endpoint builder", (Throwable)e);
        }
    }
}

