/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.groovy.dsl;

import java.io.IOException;
import java.util.Arrays;
import org.citrusframework.context.TestContext;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.groovy.dsl.GroovyShellUtils;
import org.citrusframework.script.GroovyActionBuilder;
import org.citrusframework.spi.Resource;
import org.citrusframework.util.FileUtils;
import org.codehaus.groovy.control.customizers.ImportCustomizer;

public class GroovySupport {
    private TestContext context;
    private Object delegate;

    public static GroovySupport groovy() {
        return new GroovySupport();
    }

    public GroovyActionBuilder actions() {
        return GroovyActionBuilder.groovy();
    }

    public Object load(String script) {
        return this.load(script, new ImportCustomizer());
    }

    public Object load(String script, String ... imports) {
        ImportCustomizer importCustomizer = new ImportCustomizer();
        String[] packageNames = (String[])Arrays.stream(imports).filter(it -> it.endsWith(".*")).map(it -> it.substring(0, it.length() - 2)).toArray(String[]::new);
        String[] classNames = (String[])Arrays.stream(imports).filter(it -> !it.endsWith(".*")).toArray(String[]::new);
        if (packageNames.length > 0) {
            importCustomizer.addStarImports(packageNames);
        }
        if (classNames.length > 0) {
            importCustomizer.addImports(classNames);
        }
        return this.load(script, importCustomizer);
    }

    public Object load(String script, ImportCustomizer importCustomizer) {
        String resolvedScript = this.context != null ? this.context.replaceDynamicContentInString(script) : script;
        if (this.delegate != null) {
            return GroovyShellUtils.run(importCustomizer, this.delegate, resolvedScript, null, this.context);
        }
        return GroovyShellUtils.run(importCustomizer, resolvedScript, null, this.context);
    }

    public Object load(Resource resource) {
        try {
            return this.load(FileUtils.readToString((Resource)resource));
        }
        catch (IOException e) {
            throw new CitrusRuntimeException("Failed to read Groovy script resource", (Throwable)e);
        }
    }

    public GroovySupport withDelegate(Object delegate) {
        this.delegate = delegate;
        return this;
    }

    public GroovySupport withTestContext(TestContext context) {
        this.context = context;
        return this;
    }
}

