/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.script;

import java.io.IOException;
import java.nio.charset.Charset;
import org.citrusframework.AbstractTestActionBuilder;
import org.citrusframework.actions.AbstractTestAction;
import org.citrusframework.context.TestContext;
import org.citrusframework.endpoint.Endpoint;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.groovy.dsl.configuration.endpoints.EndpointConfigurationScript;
import org.citrusframework.spi.Resource;
import org.citrusframework.util.FileUtils;
import org.citrusframework.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateEndpointsAction
extends AbstractTestAction {
    private static final Logger logger = LoggerFactory.getLogger(CreateEndpointsAction.class);
    private final String script;
    private final String scriptResourcePath;

    public CreateEndpointsAction(Builder builder) {
        super("groovy-endpoints", (AbstractTestActionBuilder)builder);
        this.script = builder.script;
        this.scriptResourcePath = builder.scriptResourcePath;
    }

    public void doExecute(TestContext context) {
        try {
            if (!StringUtils.hasText((String)this.script) && this.scriptResourcePath == null) {
                throw new CitrusRuntimeException("Neither inline script nor external script resource is defined. Unable to execute groovy script.");
            }
            String resolvedScript = StringUtils.hasText((String)this.script) ? this.script.trim() : FileUtils.readToString((Resource)FileUtils.getFileResource((String)this.scriptResourcePath, (TestContext)context));
            resolvedScript = context.replaceDynamicContentInString(resolvedScript.trim());
            new EndpointConfigurationScript(resolvedScript, context.getReferenceResolver()){

                @Override
                protected void onCreate(Endpoint endpoint) {
                    logger.info("Creating endpoint from script configuration: %s".formatted(endpoint.getName()));
                }
            }.execute(context);
        }
        catch (IOException e) {
            throw new CitrusRuntimeException("Failed to load endpoint configuration script", (Throwable)e);
        }
    }

    public String getScript() {
        return this.script;
    }

    public String getScriptResourcePath() {
        return this.scriptResourcePath;
    }

    public static final class Builder
    extends AbstractTestActionBuilder<CreateEndpointsAction, Builder> {
        private String script;
        private String scriptResourcePath;

        public Builder script(String script) {
            this.script = script;
            return this;
        }

        public Builder script(Resource scriptResource) {
            return this.script(scriptResource, FileUtils.getDefaultCharset());
        }

        public Builder script(Resource scriptResource, Charset charset) {
            try {
                this.script = FileUtils.readToString((Resource)scriptResource, (Charset)charset);
            }
            catch (IOException e) {
                throw new CitrusRuntimeException("Failed to read script resource file", (Throwable)e);
            }
            return this;
        }

        public Builder scriptResourcePath(String scriptResourcePath) {
            this.scriptResourcePath = scriptResourcePath;
            return this;
        }

        public CreateEndpointsAction build() {
            return new CreateEndpointsAction(this);
        }
    }
}

