/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.groovy;

import java.io.IOException;
import org.citrusframework.TestSource;
import org.citrusframework.common.DefaultTestLoader;
import org.citrusframework.common.TestSourceAware;
import org.citrusframework.groovy.dsl.GroovyShellUtils;
import org.citrusframework.groovy.dsl.test.TestCaseScript;
import org.citrusframework.spi.Resource;
import org.citrusframework.spi.Resources;
import org.citrusframework.util.FileUtils;
import org.codehaus.groovy.control.customizers.ImportCustomizer;

public class GroovyTestLoader
extends DefaultTestLoader
implements TestSourceAware {
    private TestSource source;

    protected void doLoad() {
        try {
            Resource scriptSource = this.getSource().getSourceFile(this.context);
            ImportCustomizer ic = new ImportCustomizer();
            String basePath = scriptSource instanceof Resources.ClasspathResource ? FileUtils.getBasePath((String)scriptSource.getLocation()) : scriptSource.getFile().getParent();
            String source = FileUtils.readToString((Resource)scriptSource);
            GroovyShellUtils.autoAddImports(source, ic);
            this.testCase = this.runner.getTestCase();
            this.configurer.forEach(it -> it.accept(this.testCase));
            this.runner.start();
            GroovyShellUtils.run(ic, new TestCaseScript(this.citrus, this.runner, this.context, basePath), source, this.citrus, this.context);
            this.handler.forEach(it -> it.accept(this.testCase));
        }
        catch (IOException e) {
            throw this.context.handleError(this.testName, this.packageName, "Failed to load Groovy test source '" + this.testName + "'", (Exception)e);
        }
    }

    public TestSource getSource() {
        if (this.source != null) {
            return this.source;
        }
        String path = this.packageName.replace('.', '/');
        Object fileName = this.testName.endsWith(".groovy") ? this.testName : this.testName + ".groovy";
        return new TestSource("groovy", this.testName, "classpath:" + path + "/" + (String)fileName);
    }

    public void setSource(TestSource source) {
        this.source = source;
    }

    public GroovyTestLoader source(String sourceFile) {
        this.setSource(new TestSource("groovy", FileUtils.getBaseName((String)FileUtils.getFileName((String)sourceFile)), sourceFile));
        return this;
    }
}

