/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.groovy.dsl.configuration.beans;

import groovy.lang.Closure;
import groovy.lang.DelegatesTo;
import groovy.lang.GroovyObjectSupport;
import groovy.lang.GroovyRuntimeException;
import groovy.lang.MissingMethodException;
import java.lang.reflect.InvocationTargetException;
import java.util.Locale;
import org.citrusframework.Citrus;
import org.citrusframework.CitrusContext;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.message.DefaultMessageQueue;
import org.citrusframework.spi.ReferenceResolver;

public class BeansConfiguration
extends GroovyObjectSupport {
    private final ReferenceResolver referenceResolver;

    public BeansConfiguration(Citrus citrus) {
        this(citrus.getCitrusContext());
    }

    public BeansConfiguration(CitrusContext citrusContext) {
        this(citrusContext.getReferenceResolver());
    }

    public BeansConfiguration(ReferenceResolver referenceResolver) {
        this.referenceResolver = referenceResolver;
    }

    public void beans(@DelegatesTo(value=BeansConfiguration.class) Closure<?> callable) {
        callable.setResolveStrategy(1);
        callable.setDelegate((Object)this);
        callable.call();
    }

    public void bean(Class<?> type) {
        this.bean(BeansConfiguration.sanitizeBeanName(type.getSimpleName()), type);
    }

    public void bean(String name, Class<?> type) {
        try {
            this.referenceResolver.bind(name, type.getConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new CitrusRuntimeException(String.format("Failed to instantiate bean of type '%s' - no default constructor available", type));
        }
    }

    public void bean(String name, Class<?> type, Closure<?> callable) {
        try {
            Object bean = type.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            callable.setResolveStrategy(3);
            callable.setDelegate(bean);
            callable.call();
            this.referenceResolver.bind(name, bean);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new CitrusRuntimeException(String.format("Failed to instantiate bean of type '%s' - no default constructor available", type));
        }
    }

    public void bean(String name, Closure<?> callable) {
        Object bean = callable.call();
        if (bean == null) {
            throw new CitrusRuntimeException("Failed to instantiate bean from closure - expected bean instance return value but was null");
        }
        this.referenceResolver.bind(name, bean);
    }

    public void queue(String name) {
        this.referenceResolver.bind(name, (Object)new DefaultMessageQueue(name));
    }

    public void propertyMissing(String name, Object value) {
        this.referenceResolver.bind(name, value);
    }

    public Object methodMissing(String name, Object argLine) {
        Object closure2;
        if (argLine == null) {
            throw new MissingMethodException(name, BeansConfiguration.class, null);
        }
        Object[] args = (Object[])argLine;
        if (args.length == 2) {
            Class type = (Class)args[0];
            Object object = args[1];
            if (object instanceof Closure) {
                Closure closure2 = (Closure)object;
                try {
                    Object bean = type.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    closure2.setResolveStrategy(3);
                    closure2.setDelegate(bean);
                    closure2.call();
                    this.referenceResolver.bind(name, bean);
                    return bean;
                }
                catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                    throw new GroovyRuntimeException(String.format("Failed to instantiate bean of type '%s'", type), (Throwable)e);
                }
            }
        } else if (args.length == 1 && (closure2 = args[0]) instanceof Closure) {
            Closure closure3 = (Closure)closure2;
            closure3.setResolveStrategy(3);
            Object bean = closure3.call();
            this.referenceResolver.bind(name, bean);
        }
        throw new MissingMethodException(name, BeansConfiguration.class, args);
    }

    private static String sanitizeBeanName(String name) {
        return name.substring(0, 1).toLowerCase(Locale.US) + name.substring(1);
    }
}

